/*
 * Decompiled with CFR 0.152.
 */
package com.greenpepper.confluence;

import com.atlassian.bandana.BandanaContext;
import com.atlassian.bandana.BandanaManager;
import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.plugin.StateAware;
import com.atlassian.spring.container.ContainerManager;
import com.fasterxml.jackson.core.JsonParseException;
import com.greenpepper.confluence.GreenPepperServerConfiguration;
import com.greenpepper.confluence.GreenPepperUserGroup;
import com.greenpepper.server.GreenPepperServer;
import com.greenpepper.server.GreenPepperServerException;
import com.greenpepper.server.GreenPepperServerService;
import com.greenpepper.server.GreenPepperServerServiceImpl;
import com.greenpepper.server.configuration.DefaultServerProperties;
import com.greenpepper.server.database.SessionService;
import com.greenpepper.server.database.hibernate.BootstrapData;
import com.greenpepper.server.database.hibernate.HibernateSessionService;
import com.greenpepper.server.domain.dao.DocumentDao;
import com.greenpepper.server.domain.dao.ProjectDao;
import com.greenpepper.server.domain.dao.RepositoryDao;
import com.greenpepper.server.domain.dao.SystemUnderTestDao;
import com.greenpepper.server.domain.dao.hibernate.HibernateDocumentDao;
import com.greenpepper.server.domain.dao.hibernate.HibernateProjectDao;
import com.greenpepper.server.domain.dao.hibernate.HibernateRepositoryDao;
import com.greenpepper.server.domain.dao.hibernate.HibernateSystemUnderTestDao;
import com.greenpepper.server.license.Authorizer;
import com.greenpepper.server.license.OpenSourceAuthorizer;
import com.greenpepper.server.rpc.xmlrpc.GreenPepperXmlRpcServer;
import java.io.IOException;
import java.util.Properties;
import org.hibernate.dialect.HSQLDialect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreenPepperServerConfigurationActivator
implements StateAware {
    private static final Logger log = LoggerFactory.getLogger(GreenPepperServerConfigurationActivator.class);
    private final BandanaContext bandanaContext = new ConfluenceBandanaContext("_GREENPEPPER");
    private BandanaManager bandanaManager;
    private BootstrapManager bootstrapManager;
    private SettingsManager settingsManager;
    private GreenPepperServerConfiguration configuration;
    private HibernateSessionService hibernateSessionService;
    private boolean isPluginEnabled = false;
    private boolean isServerStarted = false;

    public void enabled() {
        log.info("Enabling GreenPepper Plugin");
        this.isPluginEnabled = true;
    }

    public void disabled() {
        log.info("Disabling GreenPepper Plugin");
        this.isPluginEnabled = false;
        this.shutdown();
    }

    public void setBandanaManager(BandanaManager bandanaManager) {
        this.bandanaManager = bandanaManager;
    }

    public void setBootstrapManager(BootstrapManager bootstrapManager) {
        this.bootstrapManager = bootstrapManager;
    }

    public void setSettingsManager(SettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public boolean isReady() {
        return this.isPluginEnabled && this.hibernateSessionService != null;
    }

    public void startup(boolean forceStartup) throws GreenPepperServerException {
        log.info("Starting Plugin");
        if (!this.isPluginEnabled) {
            return;
        }
        GreenPepperServerConfiguration configuration = this.getConfiguration();
        if (configuration.isSetupComplete() && !this.isServerStarted || forceStartup) {
            this.isServerStarted = false;
            try {
                this.closeSession();
                Properties properties = configuration.getProperties();
                this.injectAdditionalProperties(properties);
                HibernateSessionService sessionService = new HibernateSessionService(properties);
                log.info("Boostrapping datas");
                new BootstrapData((SessionService)sessionService, properties).execute();
                new GreenPepperUserGroup().createIfNeeded();
                OpenSourceAuthorizer authorizer = new OpenSourceAuthorizer(sessionService, properties);
                authorizer.initialize(GreenPepperServer.versionDate());
                HibernateProjectDao projectDao = new HibernateProjectDao((SessionService)sessionService);
                HibernateRepositoryDao repositoryDao = new HibernateRepositoryDao((SessionService)sessionService);
                HibernateSystemUnderTestDao sutDao = new HibernateSystemUnderTestDao((SessionService)sessionService);
                HibernateDocumentDao documentDao = new HibernateDocumentDao((SessionService)sessionService);
                Object object = ContainerManager.getComponent((String)"greenPepperServerService");
                GreenPepperServerServiceImpl service = (GreenPepperServerServiceImpl)object;
                service.setAuthorizer((Authorizer)authorizer);
                service.setDocumentDao((DocumentDao)documentDao);
                service.setProjectDao((ProjectDao)projectDao);
                service.setRepositoryDao((RepositoryDao)repositoryDao);
                service.setSessionService((SessionService)sessionService);
                service.setSutDao((SystemUnderTestDao)sutDao);
                object = ContainerManager.getComponent((String)"greenPepperXmlRpcServerService");
                GreenPepperXmlRpcServer xmlRpcServer = (GreenPepperXmlRpcServer)object;
                xmlRpcServer.setService((GreenPepperServerService)service);
                this.hibernateSessionService = sessionService;
                configuration.setSetupComplete(true);
                this.storeConfiguration(configuration);
                this.isServerStarted = true;
            }
            catch (Exception ex) {
                log.error("Starting up GreenPepper plugin", (Throwable)ex);
                throw new GreenPepperServerException("greenpepper.server.generalerror", (Throwable)ex);
            }
        }
    }

    public void shutdown() {
        log.info("Shutting down Plugin");
        this.closeSession();
    }

    private void closeSession() {
        if (this.hibernateSessionService != null) {
            this.hibernateSessionService.close();
        }
        this.hibernateSessionService = null;
        this.isServerStarted = false;
    }

    private void injectAdditionalProperties(Properties sProperties) {
        sProperties.setProperty("baseUrl", this.settingsManager.getGlobalSettings().getBaseUrl());
        sProperties.setProperty("confluence.home", this.getConfluenceHome());
        sProperties.setProperty("com.greenpepper.server.runner.spi.DefaultRunnerBuilder", "com.greenpepper.server.runner.confluence5.ConfluenceDefaultRunnerBuilder");
    }

    public GreenPepperServerConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = this.getConfigurationFromBandana();
        }
        return this.configuration;
    }

    public void storeConfiguration(GreenPepperServerConfiguration configuration) {
        this.storeConfigurationToBandana(configuration);
    }

    private GreenPepperServerConfiguration getConfigurationFromBandana() {
        Object value = this.getValue(GreenPepperServerConfiguration.class);
        if (value == null) {
            this.configuration = new GreenPepperServerConfiguration();
            this.storeConfigurationToBandana(this.configuration);
        } else {
            try {
                this.configuration = GreenPepperServerConfiguration.fromString(value.toString());
            }
            catch (JsonParseException e) {
                throw new RuntimeException("Problem retrieving greenpepper configuration ", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Problem retrieving greenpepper configuration ", e);
            }
        }
        return this.configuration;
    }

    private void storeConfigurationToBandana(GreenPepperServerConfiguration configuration) {
        this.bandanaManager.setValue(this.bandanaContext, GreenPepperServerConfiguration.class.getName(), (Object)configuration.toString());
    }

    private Object getValue(Class<?> classKey) {
        return this.bandanaManager.getValue(this.bandanaContext, classKey.getName());
    }

    public String getConfigJnriUrl() {
        return (String)this.getConfiguration().getProperties().get("config$hibernate.connection.datasource");
    }

    public String getConfigDialect() {
        return (String)this.getConfiguration().getProperties().get("config$hibernate.dialect");
    }

    public void initQuickInstallConfiguration() throws GreenPepperServerException {
        GreenPepperServerConfiguration configuration = this.getConfiguration();
        DefaultServerProperties properties = new DefaultServerProperties();
        properties.put("hibernate.c3p0.acquire_increment", "1");
        properties.put("hibernate.c3p0.idle_test_period", "100");
        properties.put("hibernate.c3p0.max_size", "15");
        properties.put("hibernate.c3p0.max_statements", "0");
        properties.put("hibernate.c3p0.min_size", "0");
        properties.put("hibernate.c3p0.timeout", "30");
        properties.remove("hibernate.connection.datasource");
        properties.put("hibernate.connection.driver_class", "org.hsqldb.jdbcDriver");
        properties.put("hibernate.connection.url", "jdbc:hsqldb:" + this.getConfluenceHome() + "/database/gpsdb");
        properties.put("hibernate.connection.username", "sa");
        properties.put("hibernate.connection.password", "");
        properties.put("hibernate.dialect", HSQLDialect.class.getName());
        configuration.setProperties((Properties)properties);
        this.startup(true);
    }

    public void initCustomInstallConfiguration(String hibernateDialect, String jndiUrl) throws GreenPepperServerException {
        GreenPepperServerConfiguration configuration = this.getConfiguration();
        DefaultServerProperties properties = new DefaultServerProperties();
        properties.put("hibernate.connection.datasource", jndiUrl);
        properties.put("config$hibernate.connection.datasource", jndiUrl);
        properties.put("hibernate.dialect", hibernateDialect);
        properties.put("config$hibernate.dialect", hibernateDialect);
        if (hibernateDialect.indexOf("Oracle") != -1) {
            properties.put("hibernate.statement_cache.size", "0");
            properties.put("hibernate.jdbc.batch_size", "0");
            properties.put("hibernate.jdbc.wrap_result_sets", "true");
        }
        configuration.setProperties((Properties)properties);
        this.startup(true);
    }

    private String getConfluenceHome() {
        return this.bootstrapManager.getConfluenceHome();
    }
}

