/*
 * Decompiled with CFR 0.152.
 */
package com.greenpepper.confluence.actions.execution;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.util.ContentComparatorFactory;
import com.greenpepper.confluence.actions.SpecificationAction;
import com.greenpepper.server.GreenPepperServerException;
import com.greenpepper.server.domain.SystemUnderTest;
import com.greenpepper.util.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractListExecutionAction
extends SpecificationAction {
    protected LinkedList<Page> executableList;
    protected List<SystemUnderTest> forcedSystemUnderTests;
    private String forcedSuts;
    private String sortType = "title";
    private Boolean reverse = Boolean.FALSE;
    private Boolean openInSameWindow = Boolean.TRUE;
    private boolean showList;

    public LinkedList<Page> getExecutableList() {
        if (this.executableList != null) {
            return this.executableList;
        }
        this.executableList = new LinkedList();
        this.buildExecutableList();
        this.sortList();
        return this.executableList;
    }

    public List<SystemUnderTest> getForcedSystemUnderTests() {
        try {
            if (this.forcedSystemUnderTests != null) {
                return this.forcedSystemUnderTests;
            }
            if (StringUtil.isEmpty((String)this.forcedSuts)) {
                return this.gpUtil.getSystemsUnderTests(this.spaceKey);
            }
            ArrayList<SystemUnderTest> forcedSystemUnderTests = new ArrayList<SystemUnderTest>();
            List<SystemUnderTest> projectSuts = this.gpUtil.getSystemsUnderTests(this.spaceKey);
            for (String sutName : this.forcedSuts.split(",")) {
                sutName = sutName.trim();
                for (SystemUnderTest sut : projectSuts) {
                    if (!sut.getName().equals(sutName)) continue;
                    forcedSystemUnderTests.add(sut);
                }
            }
            return forcedSystemUnderTests;
        }
        catch (GreenPepperServerException e) {
            return new ArrayList<SystemUnderTest>();
        }
    }

    public String getForcedSuts() {
        return this.forcedSuts;
    }

    public void setForcedSuts(String forcedSuts) {
        this.forcedSuts = forcedSuts;
    }

    public boolean getShowList() {
        return this.showList;
    }

    public void setShowList(boolean showList) {
        this.showList = showList;
    }

    public boolean isExecutable() {
        List<SystemUnderTest> forcedSystemUnderTests = this.getForcedSystemUnderTests();
        return forcedSystemUnderTests != null && !forcedSystemUnderTests.isEmpty() && !this.getExecutableList().isEmpty();
    }

    public Boolean getReverse() {
        return this.reverse;
    }

    public void setReverse(Boolean reverse) {
        this.reverse = reverse;
    }

    public String getSortType() {
        return this.sortType;
    }

    public void setSortType(String sortType) {
        this.sortType = StringUtil.toEmptyIfNull((String)sortType);
    }

    public abstract void buildExecutableList();

    private void sortList() {
        try {
            if (StringUtil.isEmpty((String)this.sortType)) {
                if (this.reverse.booleanValue()) {
                    Collections.reverse(this.executableList);
                }
            } else {
                Collections.sort(this.executableList, ContentComparatorFactory.getComparator((String)this.sortType, (boolean)this.reverse));
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public Boolean getOpenInSameWindow() {
        return this.openInSameWindow;
    }

    public void setOpenInSameWindow(Boolean openInSameWindow) {
        this.openInSameWindow = openInSameWindow;
    }
}

