/*
 * Decompiled with CFR 0.152.
 */
package com.greenpepper.confluence.actions.server;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceType;
import com.atlassian.confluence.spaces.SpacesQuery;
import com.greenpepper.confluence.actions.server.GreenPepperServerAction;
import com.greenpepper.server.GreenPepperServerException;
import com.greenpepper.server.domain.ClasspathSet;
import com.greenpepper.server.domain.EnvironmentType;
import com.greenpepper.server.domain.Runner;
import com.greenpepper.server.license.LicenseBean;
import com.greenpepper.util.StringUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;

public class ConfigurationAction
extends GreenPepperServerAction {
    private static final String NONE_SELECTED = null;
    private List<Runner> runners;
    private List<EnvironmentType> envTypes;
    private Runner selectedRunner;
    private String selectedRunnerName;
    private String classpath;
    private String newRunnerName = "";
    private String newCmdLineTemplate = "";
    private String newMainClass;
    private String newServerName;
    private String newServerPort;
    private String newEnvType = "";
    private boolean secured;
    private boolean addMode;
    private boolean editPropertiesMode;
    private boolean editClasspathsMode;
    private String newLicense;
    private LicenseBean license;

    public List<Space> getSpaces() {
        SpacesQuery.Builder newQueryBuilder = SpacesQuery.newQuery();
        newQueryBuilder.withSpaceType(SpaceType.GLOBAL);
        SpacesQuery globalSpaceQuery = newQueryBuilder.build();
        return this.gpUtil.getSpaceManager().getAllSpaces(globalSpaceQuery);
    }

    public String getConfiguration() {
        if (this.isServerReady()) {
            this.doGetRunners();
        }
        return "success";
    }

    public String uploadLicense() {
        try {
            this.gpUtil.getGPServerService().uploadNewLicense(this.newLicense.replaceAll(" ", "+"));
        }
        catch (GreenPepperServerException e) {
            this.addActionError(e.getId());
        }
        return "success";
    }

    public String testConnection() {
        return "success";
    }

    public String updateConfiguration() {
        if (this.isServerReady()) {
            this.doGetRunners();
        }
        return "success";
    }

    public LicenseBean getLicense() {
        try {
            if (this.license != null) {
                return this.license;
            }
            this.license = this.gpUtil.getGPServerService().license();
        }
        catch (GreenPepperServerException e) {
            this.license = new LicenseBean();
        }
        return this.license;
    }

    public String verifyServerReady() {
        if (!this.isServerReady()) {
            this.addActionError("greenpepper.server.noconfiguration");
        }
        return "success";
    }

    public String doGetRunners() {
        if (!this.isServerReady()) {
            this.addActionError("greenpepper.server.noconfiguration");
            return "success";
        }
        try {
            this.envTypes = this.getService().getAllEnvironmentTypes();
            this.runners = this.getService().getAllRunners();
            if (!StringUtil.isEmpty((String)this.selectedRunnerName)) {
                for (Runner runner : this.runners) {
                    if (!runner.getName().equals(this.selectedRunnerName)) continue;
                    this.selectedRunner = runner;
                    return "success";
                }
            }
            this.editPropertiesMode = false;
            this.editClasspathsMode = false;
            this.selectedRunnerName = NONE_SELECTED;
        }
        catch (GreenPepperServerException e) {
            this.addActionError(e.getId());
        }
        return "success";
    }

    public String doAddRunner() {
        try {
            this.selectedRunner = Runner.newInstance((String)this.newRunnerName);
            this.selectedRunner.setCmdLineTemplate(this.newCmdLineTemplate);
            this.selectedRunner.setMainClass(this.newMainClass);
            this.selectedRunner.setServerName(this.newServerName);
            this.selectedRunner.setServerPort(this.newServerPort);
            this.selectedRunner.setEnvironmentType(EnvironmentType.newInstance((String)this.newEnvType));
            this.selectedRunner.setSecured(Boolean.valueOf(this.secured));
            this.getService().createRunner(this.selectedRunner);
            this.successfullAction();
        }
        catch (GreenPepperServerException e) {
            this.addActionError(e.getId());
        }
        return this.doGetRunners();
    }

    public String doUpdateRunner() {
        try {
            this.selectedRunner = this.getService().getRunner(this.selectedRunnerName);
            this.selectedRunner.setName(this.newRunnerName);
            this.selectedRunner.setCmdLineTemplate(this.newCmdLineTemplate);
            this.selectedRunner.setMainClass(this.newMainClass);
            this.selectedRunner.setServerName(this.newServerName);
            this.selectedRunner.setServerPort(this.newServerPort);
            this.selectedRunner.setEnvironmentType(EnvironmentType.newInstance((String)this.newEnvType));
            this.selectedRunner.setSecured(Boolean.valueOf(this.secured));
            this.getService().updateRunner(this.selectedRunnerName, this.selectedRunner);
            this.successfullAction();
            return this.doGetRunners();
        }
        catch (GreenPepperServerException e) {
            try {
                this.runners = this.getService().getAllRunners();
                this.selectedRunner.setName(this.selectedRunnerName);
            }
            catch (GreenPepperServerException e1) {
                this.addActionError(e.getId());
            }
            this.addActionError(e.getId());
            return "success";
        }
    }

    public String doRemoveRunner() {
        try {
            this.getService().removeRunner(this.selectedRunnerName);
        }
        catch (GreenPepperServerException e) {
            this.addActionError(e.getId());
        }
        return this.doGetRunners();
    }

    public String doEditClasspath() {
        try {
            this.selectedRunner = this.getService().getRunner(this.selectedRunnerName);
            this.selectedRunner.setClasspaths((SortedSet)ClasspathSet.parse((String)this.classpath));
            this.getService().updateRunner(this.selectedRunnerName, this.selectedRunner);
        }
        catch (GreenPepperServerException e) {
            this.addActionError(e.getId());
        }
        return this.doGetRunners();
    }

    public Set<String> getClasspaths() {
        SortedSet classpaths = this.selectedRunner.getClasspaths();
        return classpaths == null ? new HashSet() : classpaths;
    }

    public String getClasspathsAsTextAreaContent() {
        StringBuilder sb = new StringBuilder();
        for (String classpath : this.getClasspaths()) {
            sb.append(classpath);
            sb.append("\r");
        }
        return sb.toString();
    }

    public String getClasspathTitle() {
        return this.getText("greenpepper.runners.classpath");
    }

    public String getNewLicense() {
        return this.newLicense;
    }

    public void setNewLicense(String newLicense) {
        this.newLicense = newLicense;
    }

    public List<Runner> getRunners() {
        return this.runners;
    }

    public String getSelectedRunnerName() {
        return this.selectedRunnerName;
    }

    public void setSelectedRunnerName(String selectedRunnerName) {
        this.selectedRunnerName = selectedRunnerName.equals("none") ? null : selectedRunnerName;
    }

    public boolean isAddMode() {
        return this.addMode;
    }

    public void setAddMode(boolean addMode) {
        this.addMode = addMode;
    }

    public boolean isEditPropertiesMode() {
        return this.editPropertiesMode;
    }

    public void setEditPropertiesMode(boolean editPropertiesMode) {
        this.editPropertiesMode = editPropertiesMode;
    }

    public boolean isEditClasspathsMode() {
        return this.editClasspathsMode;
    }

    public void setEditClasspathsMode(boolean editClasspathsMode) {
        this.editClasspathsMode = editClasspathsMode;
    }

    public Runner getSelectedRunner() {
        return this.selectedRunner;
    }

    public String getClasspath() {
        return this.classpath;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath.trim();
    }

    public String getNewMainClass() {
        return this.newMainClass;
    }

    public void setNewMainClass(String newMainClass) {
        this.newMainClass = newMainClass.trim();
    }

    public String getNewRunnerName() {
        return this.newRunnerName;
    }

    public void setNewRunnerName(String newRunnerName) {
        this.newRunnerName = newRunnerName.trim();
    }

    public String getNewServerName() {
        return this.newServerName;
    }

    public void setNewServerName(String newServerName) {
        this.newServerName = newServerName.trim();
    }

    public String getNewServerPort() {
        return this.newServerPort;
    }

    public void setNewServerPort(String newServerPort) {
        this.newServerPort = newServerPort.trim();
    }

    public String getNewEnvType() {
        return this.newEnvType;
    }

    public void setNewEnvType(String newEnvType) {
        this.newEnvType = newEnvType;
    }

    public void setRunners(List<Runner> runners) {
        this.runners = runners;
    }

    public List<EnvironmentType> getEnvTypes() {
        return this.envTypes;
    }

    public void setEnvTypes(List<EnvironmentType> envTypes) {
        this.envTypes = envTypes;
    }

    public String getNewCmdLineTemplate() {
        return this.newCmdLineTemplate;
    }

    public void setNewCmdLineTemplate(String newCmdLineTemplate) {
        this.newCmdLineTemplate = newCmdLineTemplate.trim();
    }

    private void successfullAction() {
        this.addMode = false;
        this.editPropertiesMode = false;
        this.editClasspathsMode = false;
        this.secured = false;
        this.selectedRunnerName = this.newRunnerName;
        this.newRunnerName = "";
        this.newServerName = "";
        this.newServerPort = "";
        this.newEnvType = "";
        this.newCmdLineTemplate = "";
    }

    public boolean isSecured() {
        return this.secured;
    }

    public void setSecured(boolean secured) {
        this.secured = secured;
    }
}

