/*
 * Decompiled with CFR 0.152.
 */
package com.greenpepper.confluence.listeners;

import com.atlassian.confluence.event.events.content.page.PageEvent;
import com.atlassian.confluence.event.events.content.page.PageRemoveEvent;
import com.atlassian.confluence.event.events.content.page.PageTrashedEvent;
import com.atlassian.confluence.event.events.content.page.PageUpdateEvent;
import com.atlassian.confluence.event.events.space.SpaceRemoveEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.event.Event;
import com.atlassian.event.EventListener;
import com.greenpepper.confluence.velocity.ConfluenceGreenPepper;
import com.greenpepper.server.GreenPepperServerException;
import com.greenpepper.server.domain.Specification;
import org.apache.log4j.Logger;

public class GreenPepperPageListener
implements EventListener {
    private static Logger log = Logger.getLogger(GreenPepperPageListener.class);
    private final ConfluenceGreenPepper gp = new ConfluenceGreenPepper();

    public void handleEvent(Event evt) {
        try {
            if (evt instanceof PageUpdateEvent) {
                this.updateSpecification(evt);
            } else if (evt instanceof SpaceRemoveEvent) {
                this.removeRepository(evt);
            } else if (evt instanceof PageRemoveEvent || evt instanceof PageTrashedEvent) {
                this.removeSpecification(evt);
            }
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    private void removeSpecification(Event evt) throws GreenPepperServerException {
        PageEvent pageEvt = (PageEvent)evt;
        Page page = pageEvt.getPage();
        Specification specification = Specification.newInstance((String)page.getTitle());
        specification.setRepository(this.gp.getHomeRepository(page.getSpaceKey()));
        this.gp.getGPServerService().removeSpecification(specification);
        this.gp.saveExecuteChildren(page, null);
        this.gp.saveImplementedVersion(page, null);
        this.gp.savePreviousImplementedVersion(page, null);
    }

    private void removeRepository(Event evt) throws GreenPepperServerException {
        SpaceRemoveEvent spaceEvt = (SpaceRemoveEvent)evt;
        this.gp.getGPServerService().removeRepository(this.gp.getHomeRepository(spaceEvt.getSpace().getKey()).getUid());
    }

    private void updateSpecification(Event evt) throws GreenPepperServerException {
        PageUpdateEvent pageEvt = (PageUpdateEvent)evt;
        AbstractPage oldPage = pageEvt.getOriginalPage();
        Page newPage = pageEvt.getPage();
        if (newPage != null && oldPage != null && !newPage.getTitle().equals(oldPage.getTitle())) {
            Specification oldSpecification = Specification.newInstance((String)oldPage.getTitle());
            oldSpecification.setRepository(this.gp.getHomeRepository(newPage.getSpace().getKey()));
            try {
                Specification newSpecification = Specification.newInstance((String)newPage.getTitle());
                newSpecification.setRepository(this.gp.getHomeRepository(newPage.getSpace().getKey()));
                this.gp.getGPServerService().updateSpecification(oldSpecification, newSpecification);
            }
            catch (GreenPepperServerException e) {
                this.gp.getGPServerService().removeSpecification(oldSpecification);
            }
        }
    }

    public Class[] getHandledEventClasses() {
        return new Class[]{PageUpdateEvent.class, PageTrashedEvent.class, PageRemoveEvent.class, SpaceRemoveEvent.class};
    }
}

