/*
 * Decompiled with CFR 0.152.
 */
package com.greenpepper.confluence.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.renderer.v2.macros.BaseHttpRetrievalMacro;
import com.atlassian.confluence.util.http.HttpResponse;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.greenpepper.server.GreenPepperServerException;
import com.greenpepper.server.domain.Repository;
import com.greenpepper.server.rpc.xmlrpc.XmlRpcDataMarshaller;
import com.greenpepper.server.rpc.xmlrpc.XmlRpcMethodName;
import com.greenpepper.util.CollectionUtil;
import com.greenpepper.util.StringUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;

public abstract class AbstractHttpRetrievalMacro
extends BaseHttpRetrievalMacro
implements Macro {
    private final Logger log = Logger.getLogger(AbstractHttpRetrievalMacro.class);

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public String execute(Map<String, String> parameters, String body, ConversionContext context) throws MacroExecutionException {
        try {
            return this.execute(parameters, body, (RenderContext)context.getPageContext());
        }
        catch (MacroException e) {
            throw new MacroExecutionException((Throwable)e);
        }
    }

    public String successfulResponse(Map parameters, RenderContext context, String url, HttpResponse response) throws MacroException {
        return "BYOB";
    }

    protected String getParameter(Map parameters, String name) {
        String parameter = (String)parameters.get(name);
        return StringUtil.isBlank((String)parameter) ? null : parameter.trim();
    }

    protected Repository getRepository(String url, String handler, String jiraUid) throws GreenPepperServerException {
        Vector response;
        try {
            Repository repository = Repository.newInstance((String)jiraUid);
            Vector params = CollectionUtil.toVector((Object[])new Vector[]{repository.marshallize()});
            XmlRpcClient xmlrpc = new XmlRpcClient(url + "/rpc/xmlrpc");
            String cmdLine = new StringBuffer(handler).append(".").append(XmlRpcMethodName.getRegisteredRepository).toString();
            response = (Vector)xmlrpc.execute(cmdLine, params);
        }
        catch (XmlRpcException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            throw new GreenPepperServerException("greenpepper.server.callfailed", e.getMessage());
        }
        catch (IOException e) {
            this.log.error((Object)e.getMessage(), (Throwable)e);
            throw new GreenPepperServerException("greenpepper.server.configerror", e.getMessage());
        }
        XmlRpcDataMarshaller.checkForErrors((Object)response);
        return XmlRpcDataMarshaller.toRepository((Vector)response);
    }
}

