/*
 * Decompiled with CFR 0.152.
 */
package com.greenpepper.confluence.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.MacroException;
import com.greenpepper.confluence.macros.AbstractGreenPepperMacro;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreenPepperWiki
extends AbstractGreenPepperMacro {
    private static final Logger LOGGER = LoggerFactory.getLogger(GreenPepperWiki.class);

    @Override
    public boolean hasBody() {
        return true;
    }

    @Override
    public RenderMode getBodyRenderMode() {
        return RenderMode.ALL;
    }

    @Override
    public Macro.BodyType getBodyType() {
        return Macro.BodyType.PLAIN_TEXT;
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        try {
            return body;
        }
        catch (Exception e) {
            return GreenPepperWiki.getErrorView("greenpepper.info.macroid", e.getMessage());
        }
    }

    @Override
    public String execute(Map<String, String> parameters, String body, ConversionContext context) throws MacroExecutionException {
        try {
            String xhtmlRendered = this.gpUtil.getWikiStyleRenderer().convertWikiToXHtml((RenderContext)context.getPageContext(), body);
            LOGGER.trace("rendering : \n - source \n {} \n - output \n {}", (Object)body, (Object)xhtmlRendered);
            return xhtmlRendered;
        }
        catch (Exception e) {
            return GreenPepperWiki.getErrorView("greenpepper.info.macroid", e.getMessage());
        }
    }
}

