/*
 * Decompiled with CFR 0.152.
 */
package com.greenpepper.confluence.macros.historic;

import com.greenpepper.confluence.macros.historic.AbstractChartBuilder;
import com.greenpepper.confluence.macros.historic.ChartLongValue;
import com.greenpepper.confluence.macros.historic.HistoricParameters;
import com.greenpepper.server.GreenPepperServerException;
import com.greenpepper.server.domain.Execution;
import java.awt.Color;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.AbstractCategoryItemLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.category.StackedBarRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.data.DataUtilities;
import org.jfree.data.Values2D;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;

public class AggregationExecutionChartBuilder
extends AbstractChartBuilder {
    private static final NumberFormat PERCENT_FORMATTER = new DecimalFormat("0%");
    private final List<Execution> executions;

    private AggregationExecutionChartBuilder(HistoricParameters settings, List<Execution> executions) {
        super(settings);
        this.executions = executions;
    }

    public static AggregationExecutionChartBuilder newInstance(HistoricParameters settings, List<Execution> executions) {
        return new AggregationExecutionChartBuilder(settings, executions);
    }

    @Override
    public String generateChart() throws GreenPepperServerException {
        try {
            CategoryDataset dataset = this.generateDataset();
            JFreeChart chart = this.createChart(dataset);
            BufferedImage chartImage = this.createChartImage(chart);
            return this.getDownloadPath(chartImage);
        }
        catch (IOException e) {
            throw new GreenPepperServerException("greenpepper.server.generalexeerror", e.getMessage(), (Throwable)e);
        }
    }

    private CategoryDataset generateDataset() {
        String successLabel = this.gpUtil.getText("greenpepper.historic.success");
        String failuresLabel = this.gpUtil.getText("greenpepper.historic.failures");
        String ignoredLabel = this.gpUtil.getText("greenpepper.historic.ignored");
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (Execution exec : this.executions) {
            String category = exec.getSpecification().getName();
            ChartLongValue value = new ChartLongValue(category, exec.getId());
            double failureCount = exec.getErrors() + exec.getFailures() + (exec.hasException() ? 1 : 0);
            dataset.addValue((Number)new Double(exec.getSuccess()), (Comparable)((Object)successLabel), (Comparable)value);
            if (this.settings.isShowIgnored()) {
                dataset.addValue((Number)new Double(exec.getIgnored()), (Comparable)((Object)ignoredLabel), (Comparable)value);
            }
            dataset.addValue((Number)new Double(failureCount), (Comparable)((Object)failuresLabel), (Comparable)value);
        }
        return dataset;
    }

    private JFreeChart createChart(CategoryDataset dataset) throws IOException {
        JFreeChart chart = ChartFactory.createAreaChart((String)this.settings.getTitle(), null, null, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        this.customizeChart(chart);
        return chart;
    }

    private void customizeChart(JFreeChart chart) throws IOException {
        chart.setBackgroundPaint((Paint)Color.white);
        chart.setBorderVisible(this.settings.isBorder());
        TextTitle chartTitle = chart.getTitle();
        this.customizeTitle(chartTitle, DEFAULT_TITLE_FONT);
        this.addSubTitle(chart, this.settings.getSubTitle(), DEFAULT_SUBTITLE_FONT);
        this.addSubTitle(chart, this.settings.getSubTitle2(), DEFAULT_SUBTITLE2_FONT);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setNoDataMessage(this.gpUtil.getText("greenpepper.historic.nodata"));
        StackedBarRenderer renderer = new StackedBarRenderer(true);
        plot.setRenderer((CategoryItemRenderer)renderer);
        int index = 0;
        renderer.setSeriesPaint(index++, (Paint)GREEN_COLOR);
        if (this.settings.isShowIgnored()) {
            renderer.setSeriesPaint(index++, (Paint)Color.yellow);
        }
        renderer.setSeriesPaint(index, (Paint)Color.red);
        renderer.setToolTipGenerator((CategoryToolTipGenerator)new DefaultTooltipGenerator());
        renderer.setItemURLGenerator(new CategoryURLGenerator(){

            public String generateURL(CategoryDataset data, int series, int category) {
                Comparable valueKey = data.getColumnKey(category);
                ChartLongValue value = (ChartLongValue)valueKey;
                return "javascript:" + AggregationExecutionChartBuilder.this.settings.getExecutionUID() + "_showHistoricChart('" + value.getId() + "');";
            }
        });
        CategoryAxis domainAxis = plot.getDomainAxis();
        this.customizeAxis((Axis)domainAxis);
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_90);
        domainAxis.setCategoryMargin(0.01);
        ValueAxis rangeAxis = plot.getRangeAxis();
        this.customizeAxis((Axis)rangeAxis);
        rangeAxis.setLowerBound(0.0);
        rangeAxis.setUpperBound(1.0);
        if (rangeAxis instanceof NumberAxis) {
            NumberAxis numberAxis = (NumberAxis)rangeAxis;
            numberAxis.setTickUnit(new NumberTickUnit(0.1));
            numberAxis.setNumberFormatOverride(PERCENT_FORMATTER);
        }
        plot.setForegroundAlpha(0.8f);
    }

    private class DefaultTooltipGenerator
    extends AbstractCategoryItemLabelGenerator
    implements CategoryToolTipGenerator {
        private final Map<Integer, Double> totals;

        public DefaultTooltipGenerator() {
            super("", PERCENT_FORMATTER);
            this.totals = new HashMap<Integer, Double>();
        }

        public String generateToolTip(CategoryDataset dataset, int row, int column) {
            double base = this.getColumnTotal(dataset, column);
            Number value = dataset.getValue(row, column);
            double v = value.doubleValue();
            return String.valueOf(dataset.getColumnKey(column)) + " - " + dataset.getRowKey(row) + " - " + this.getNumberFormat().format(v / base);
        }

        private double getColumnTotal(CategoryDataset dataset, int column) {
            Double total = this.totals.get(column);
            if (total == null) {
                total = DataUtilities.calculateColumnTotal((Values2D)dataset, (int)column);
                this.totals.put(column, total);
            }
            return total;
        }
    }
}

