/*
 * Decompiled with CFR 0.152.
 */
package com.greenpepper.confluence.macros.historic;

import com.atlassian.confluence.pages.Page;
import com.greenpepper.confluence.velocity.ConfluenceGreenPepper;
import com.greenpepper.server.GreenPepperServerException;
import com.greenpepper.server.domain.Repository;
import com.greenpepper.server.domain.SystemUnderTest;
import java.util.List;
import java.util.Map;

public class HistoricParameters {
    public static final String PAGETITLE = "pagetitle";
    public static final String SPACEKEY = "spacekey";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String BORDER = "border";
    public static final String CHILDREN = "children";
    public static final String MAXRESULT = "maxresult";
    public static final String SUT = "sut";
    public static final String SHOWIGNORED = "showignored";
    public static final String TITLE = "title";
    public static final String SUBTITLE = "subtitle";
    public static final String SUBTITLE2 = "subtitle2";
    public static final String LABELS = "labels";
    public static final String POPUP_WIDTH = "popupwidth";
    public static final String POPUP_HEIGHT = "popupheight";
    public static final int DEFAULT_WIDTH = 500;
    public static final int DEFAULT_HEIGHT = 500;
    public static final int DEFAULT_MAXRESULT = 30;
    public static final int DEFAULT_POPUP_WIDTH = 800;
    public static final int DEFAULT_POPUP_HEIGHT = 600;
    private final ConfluenceGreenPepper gpUtil = new ConfluenceGreenPepper();
    private final String spaceKey;
    private final Page page;
    private final String executionUID;
    private final int width;
    private final int height;
    private final boolean border;
    private final Children children;
    private final int maxResult;
    private final SystemUnderTest targetedSystemUnderTest;
    private final boolean showIgnored;
    private final String title;
    private final String subTitle;
    private final String subTitle2;
    private final String labels;
    private final int popupWidth;
    private final int popupHeight;

    public HistoricParameters(Map parameters, String spaceKey, Page page, String executionUID) throws GreenPepperServerException {
        this.spaceKey = spaceKey;
        this.page = page;
        this.executionUID = executionUID;
        this.width = this.getParameters(parameters, WIDTH, 500);
        this.height = this.getParameters(parameters, HEIGHT, 500);
        this.border = this.getParameters(parameters, BORDER, false);
        this.children = this.getParameters(parameters, CHILDREN, Children.False);
        this.maxResult = this.getParameters(parameters, MAXRESULT, 30);
        this.targetedSystemUnderTest = this.getSutParameter(parameters, SUT, page);
        this.showIgnored = this.getParameters(parameters, SHOWIGNORED, false);
        this.title = this.getParameters(parameters, TITLE, (String)null);
        this.subTitle = this.getParameters(parameters, SUBTITLE, (String)null);
        this.subTitle2 = this.getParameters(parameters, SUBTITLE2, (String)null);
        this.labels = this.getParameters(parameters, LABELS, (String)null);
        this.popupWidth = this.getParameters(parameters, POPUP_WIDTH, this.isNoChildren() ? 800 : this.width);
        this.popupHeight = this.getParameters(parameters, POPUP_HEIGHT, this.isNoChildren() ? 600 : this.height);
    }

    public Page getPage() {
        return this.page;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public String getExecutionUID() {
        return this.executionUID;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isBorder() {
        return this.border;
    }

    public Children getChildren() {
        return this.children;
    }

    public boolean isNoChildren() {
        return Children.False == this.children;
    }

    public boolean isAllChildren() {
        return Children.All == this.children;
    }

    public boolean isFirstChildren() {
        return Children.First == this.children;
    }

    public int getMaxResult() {
        return this.maxResult;
    }

    public SystemUnderTest getTargetedSystemUnderTest() {
        return this.targetedSystemUnderTest;
    }

    public String getSut() {
        return this.getTargetedSystemUnderTest().getName();
    }

    public boolean isShowIgnored() {
        return this.showIgnored;
    }

    public boolean getIsShowIgnored() {
        return this.isShowIgnored();
    }

    public String getTitle() {
        return this.title == null ? this.getDefaultTitle() : this.title;
    }

    public String getSubTitle() {
        return this.subTitle == null ? this.getDefaultSubTitle() : this.subTitle;
    }

    public String getSubTitle2() {
        return this.subTitle2 == null ? this.getDefaultSubTitle2() : this.subTitle2;
    }

    public String getLabels() {
        return this.labels;
    }

    public int getPopupHeight() {
        return this.popupHeight;
    }

    public int getPopupWidth() {
        return this.popupWidth;
    }

    private String getDefaultTitle() {
        return this.gpUtil.getText("greenpepper.historic.chart.title");
    }

    private String getDefaultSubTitle() {
        StringBuilder subTitle = new StringBuilder();
        if (this.getLabels() != null) {
            subTitle.append(this.gpUtil.getText("greenpepper.execution.forlabels")).append(' ').append(this.gpUtil.getText("greenpepper.execution.openbraket")).append(' ').append(this.getLabels()).append(' ').append(this.gpUtil.getText("greenpepper.execution.closebraket")).append(' ').append(this.gpUtil.getText("greenpepper.execution.and")).append(' ');
        }
        subTitle.append(this.gpUtil.getText("greenpepper.execution.for"));
        if (!this.isNoChildren()) {
            subTitle.append(this.isAllChildren() ? this.gpUtil.getText("greenpepper.children.all") : this.gpUtil.getText("greenpepper.children.firstlvl")).append(' ').append(this.gpUtil.getText("greenpepper.children.childrenof")).append(' ');
        }
        subTitle.append(this.gpUtil.getText("greenpepper.execution.openbraket")).append(' ').append(this.getPage().getTitle().trim()).append(' ').append(this.gpUtil.getText("greenpepper.execution.closebraket"));
        subTitle.append(' ').append(this.gpUtil.getText("greenpepper.execution.on")).append(' ').append(this.getSpaceKey()).append(' ').append(this.gpUtil.getText("greenpepper.execution.space"));
        return subTitle.toString();
    }

    private String getDefaultSubTitle2() {
        return this.gpUtil.getText("greenpepper.historic.chart.subtitle2", this.getSut(), this.getMaxResult());
    }

    private String getParameters(Map parameters, String parameterName, String defaultValue) {
        String value = (String)parameters.get(parameterName);
        return value == null ? defaultValue : value;
    }

    private int getParameters(Map parameters, String parameterName, int defaultValue) {
        String value = (String)parameters.get(parameterName);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    private boolean getParameters(Map parameters, String parameterName, boolean defaultValue) {
        String value = (String)parameters.get(parameterName);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    private Children getParameters(Map parameters, String parameterName, Children defaultValue) {
        String value = (String)parameters.get(parameterName);
        return value == null ? defaultValue : Children.toChildren(value);
    }

    private SystemUnderTest getSutParameter(Map parameters, String parameterName, Page page) throws GreenPepperServerException {
        String sut = (String)parameters.get(parameterName);
        if (sut == null) {
            if (this.gpUtil.isExecutable(page)) {
                String selectedSut = this.gpUtil.getSelectedSystemUnderTestInfo(this.getPage());
                sut = selectedSut.substring(selectedSut.indexOf(64) + 1);
            } else {
                Repository repository = this.gpUtil.getHomeRepository(this.getSpaceKey());
                List allSuts = this.gpUtil.getGPServerService().getSystemUnderTestsOfAssociatedProject(repository.getUid());
                for (SystemUnderTest s : allSuts) {
                    if (!s.isDefault()) continue;
                    return s;
                }
            }
        }
        return this.findTargetSystemUnderTest(sut, this.getSpaceKey());
    }

    private SystemUnderTest findTargetSystemUnderTest(String sut, String spaceKey) throws GreenPepperServerException {
        SystemUnderTest targetedSystemUnderTest = null;
        List<SystemUnderTest> suts = this.gpUtil.getSystemsUnderTests(spaceKey);
        for (SystemUnderTest s : suts) {
            if (!s.getName().equals(sut)) continue;
            targetedSystemUnderTest = s;
            break;
        }
        if (targetedSystemUnderTest == null) {
            throw new GreenPepperServerException("greenpepper.historic.sutnotinselection", sut);
        }
        return targetedSystemUnderTest;
    }

    public static enum Children {
        False,
        First,
        All;


        public static Children toChildren(String id) {
            if (id.equalsIgnoreCase("first")) {
                return First;
            }
            if (id.equalsIgnoreCase("all")) {
                return All;
            }
            return False;
        }
    }
}

