/*
 * Decompiled with CFR 0.152.
 */
package com.greenpepper.confluence.velocity;

import com.atlassian.config.bootstrap.AtlassianBootstrapManager;
import com.atlassian.config.util.BootstrapUtils;
import com.atlassian.confluence.content.render.xhtml.Renderer;
import com.atlassian.confluence.content.render.xhtml.compatibility.BodyTypeAwareRenderer;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPermissionManager;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.rpc.auth.TokenAuthenticationManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUserPreferences;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.atlassian.renderer.WikiStyleRenderer;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.User;
import com.greenpepper.confluence.GreenPepperServerConfiguration;
import com.greenpepper.confluence.GreenPepperServerConfigurationActivator;
import com.greenpepper.confluence.GreenPepperUserGroup;
import com.greenpepper.confluence.actions.SpecificationAction;
import com.greenpepper.confluence.utils.ConfluenceVersion;
import com.greenpepper.report.XmlReport;
import com.greenpepper.server.GreenPepperServer;
import com.greenpepper.server.GreenPepperServerException;
import com.greenpepper.server.GreenPepperServerService;
import com.greenpepper.server.domain.Project;
import com.greenpepper.server.domain.Reference;
import com.greenpepper.server.domain.Repository;
import com.greenpepper.server.domain.Specification;
import com.greenpepper.server.domain.SystemUnderTest;
import com.greenpepper.util.I18nUtil;
import com.greenpepper.util.Period;
import com.greenpepper.util.StringUtil;
import com.opensymphony.webwork.ServletActionContext;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.springframework.transaction.PlatformTransactionManager;

public class ConfluenceGreenPepper {
    public static final String EXECUTION_KEY = "greenpeeper.executionKey";
    public static final String EXECUTE_CHILDREN = "greenpeeper.executeChildren";
    public static final String IMPLEMENTED_VERSION = "greenpeeper.implementedversion";
    public static final String PREVIOUS_IMPLEMENTED_VERSION = "greenpeeper.previous.implementedversion";
    public static final String NEVER_IMPLEMENTED = "greenpepper.page.neverimplemented";
    public static final String SERVER_NOCONFIGURATION = "greenpepper.server.noconfiguration";
    public static final String ANONYMOUS_ACCESS_DENIED = "greenpepper.anonymous.accessdenied";
    public static final String USER_NOTMEMBEROF_GREENPEPPERUSERS_GROUP = "greenpepper.notmemberof.greenpepperusers.group";
    public static final String PLUGIN_NOT_INSTALLED_UNDER_WEBINFLIB = "greenpepper.server.plugin.notinstalledunderwebinflib";
    public static final String REPOSITORY_BASEURL_OUTOFSYNC = "greenpepper.server.repourloutofsync";
    private static Logger log = Logger.getLogger(ConfluenceGreenPepper.class);
    private static final String RESOURCE_BUNDLE = SpecificationAction.class.getName();
    private static final int CRITICAL_PERIOD = 29;
    private GreenPepperServerService service;
    private GreenPepperServerConfigurationActivator configurationActivator;
    private TokenAuthenticationManager tokenManager;
    private PlatformTransactionManager transactionManager;
    private SettingsManager settingsManager;
    private AtlassianBootstrapManager bootstrapManager;
    private ContentPropertyManager contentPropertyManager;
    private ContentPermissionManager contentPermissionManager;
    private ContentEntityManager contentEntityManager;
    private WikiStyleRenderer wikiStyleRenderer;
    private PageManager pageManager;
    private SpaceManager spaceManager;
    private SpacePermissionManager spacePermissionManager;
    private LabelManager labelManager;
    private UserAccessor userAccessor;
    private FormatSettingsManager formatSettingsManager;
    private GreenPepperUserGroup gpUserGroup;
    private Renderer viewRenderer;
    private BodyTypeAwareRenderer bodyTypeAwareRenderer;
    private final ThreadLocal<Locale> threadLocale = new ThreadLocal();
    private ResourceBundle resourceBundle;

    public String getVersion() {
        return "4.0.1";
    }

    public String getVersionDate() {
        DateFormat df = DateFormat.getDateTimeInstance(3, 3);
        return df.format(GreenPepperServer.versionDate());
    }

    public ConfluenceVersion getConfluenceVersion() {
        return ConfluenceVersion.getCurrentVersion();
    }

    public boolean isConfluenceVersion28() {
        return this.getConfluenceVersion().equals(ConfluenceVersion.V28X);
    }

    public boolean isConfluenceVersion29() {
        return this.getConfluenceVersion().equals(ConfluenceVersion.V29X);
    }

    public boolean isConfluenceVersion3() {
        ConfluenceVersion confluenceVersion = this.getConfluenceVersion();
        return confluenceVersion.compareTo(ConfluenceVersion.V30X) >= 0 && confluenceVersion.compareTo(ConfluenceVersion.V40X) < 0;
    }

    public boolean isConfluenceVersion4() {
        ConfluenceVersion confluenceVersion = this.getConfluenceVersion();
        return confluenceVersion.compareTo(ConfluenceVersion.V40X) >= 0 && confluenceVersion.compareTo(ConfluenceVersion.V50X) < 0;
    }

    public boolean isConfluenceMajorVersionLessThan_2_6() {
        return this.getConfluenceVersion().compareTo(ConfluenceVersion.V26X) < 0;
    }

    public boolean isConfluenceMajorVersionLessThan_2_8() {
        return this.getConfluenceVersion().compareTo(ConfluenceVersion.V28X) < 0;
    }

    public boolean isConfluenceMajorVersionGreaterOrEqualThan_2_8() {
        return this.getConfluenceVersion().compareTo(ConfluenceVersion.V28X) >= 0;
    }

    @HtmlSafe
    public String getText(String key) {
        return I18nUtil.getText((String)key, (ResourceBundle)this.getResourceBundle());
    }

    @HtmlSafe
    public String getText(String key, Object ... arguments) {
        return I18nUtil.getText((String)key, (ResourceBundle)this.getResourceBundle(), (Object[])arguments);
    }

    private ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            Locale locale = this.threadLocale.get();
            if (locale == null) {
                locale = new ConfluenceActionSupport().getLocale();
                this.threadLocale.set(locale == null ? Locale.ENGLISH : locale);
            }
            this.resourceBundle = ResourceBundle.getBundle(RESOURCE_BUNDLE, locale);
        }
        return this.resourceBundle;
    }

    public Repository getHomeRepository(String spaceKey) throws GreenPepperServerException {
        String uid = this.getSettingsManager().getGlobalSettings().getSiteTitle() + "-" + spaceKey;
        Repository repository = Repository.newInstance((String)uid);
        repository.setMaxUsers(this.getNumberOfUserForGreenPepperUserGroup());
        return repository;
    }

    public int getNumberOfUserForGreenPepperUserGroup() throws GreenPepperServerException {
        if (this.isCommercialLicense()) {
            return this.getGreenPepperUserGroup().getNumberOfUserForGroup();
        }
        return 1;
    }

    public String enable(String spaceKey) throws GreenPepperServerException {
        try {
            if (!this.isServerReady()) {
                return this.getText(SERVER_NOCONFIGURATION);
            }
            if (this.isCommercialLicense()) {
                User activeUser = this.getRemoteUser();
                if (activeUser == null) {
                    return this.getText(ANONYMOUS_ACCESS_DENIED);
                }
                if (!this.getGreenPepperUserGroup().hasMembership(activeUser)) {
                    return this.getText(USER_NOTMEMBEROF_GREENPEPPERUSERS_GROUP);
                }
            }
            Repository repository = this.getHomeRepository(spaceKey);
            this.getGPServerService().getRegisteredRepository(repository);
            return null;
        }
        catch (GreenPepperServerException e) {
            log.info((Object)e.getMessage());
            return this.getText(e.getId());
        }
    }

    public boolean isCommercialLicense() throws GreenPepperServerException {
        return this.getGPServerService().isCommercialLicense();
    }

    public Specification getSpecification(Page page) throws GreenPepperServerException {
        return this.getSpecification(page.getSpaceKey(), page.getTitle());
    }

    public Specification getSpecification(String spaceKey, String pageTitle) throws GreenPepperServerException {
        Specification specification = Specification.newInstance((String)pageTitle);
        specification.setRepository(this.getHomeRepository(spaceKey));
        return this.getGPServerService().getSpecification(specification);
    }

    public boolean isExecutable(Page page) {
        try {
            return this.getSpecification(page) != null;
        }
        catch (GreenPepperServerException e) {
            return false;
        }
    }

    public List<Repository> getRepositories(String spaceKey) throws GreenPepperServerException {
        Repository repository = this.getHomeRepository(spaceKey);
        List repositories = this.getGPServerService().getRequirementRepositoriesOfAssociatedProject(repository.getUid());
        return repositories;
    }

    public List<SystemUnderTest> getSystemsUnderTests(String spaceKey) throws GreenPepperServerException {
        Repository repository = this.getHomeRepository(spaceKey);
        return this.getGPServerService().getSystemUnderTestsOfAssociatedProject(repository.getUid());
    }

    public Set<SystemUnderTest> getPageSystemsUnderTests(Page page) throws GreenPepperServerException {
        return this.getPageSystemsUnderTests(page.getSpaceKey(), page.getTitle());
    }

    public Set<SystemUnderTest> getPageSystemsUnderTests(String spaceKey, String pageTitle) throws GreenPepperServerException {
        Specification specification = Specification.newInstance((String)pageTitle);
        specification.setRepository(this.getHomeRepository(spaceKey));
        Specification specificationFromGPService = this.getGPServerService().getSpecification(specification);
        return specificationFromGPService.getTargetedSystemUnderTests();
    }

    public List<Reference> getReferences(Page page) throws GreenPepperServerException {
        return this.getReferences(page.getSpaceKey(), page.getTitle());
    }

    public List<Reference> getReferences(String spaceKey, String pageTitle) throws GreenPepperServerException {
        Specification specification = Specification.newInstance((String)pageTitle);
        specification.setRepository(this.getHomeRepository(spaceKey));
        List references = this.getGPServerService().getSpecificationReferences(specification);
        return this.getUniqueReferences(references);
    }

    public String getPageContent(Page currentPage, Boolean implementedVersion) throws GreenPepperServerException {
        Page page = currentPage;
        if (implementedVersion.booleanValue()) {
            page = this.getImplementedPage(currentPage);
        }
        return this.getBodyTypeAwareRenderer().render((ContentEntityObject)page);
    }

    public String getPageContent(Page page) {
        try {
            return this.getPageContent(page, false);
        }
        catch (GreenPepperServerException e) {
            return e.getMessage();
        }
    }

    public String getSelectedSystemUnderTestInfo(String spaceKey, String pageTitle) {
        return this.getSelectedSystemUnderTestInfo(this.pageManager.getPage(spaceKey, pageTitle));
    }

    public String getSelectedSystemUnderTestInfo(Page page) {
        SystemUnderTest selectedSut = this.getSavedSelectedSystemUnderTest(page);
        SystemUnderTest defaultSut = null;
        try {
            Set<SystemUnderTest> suts = this.getPageSystemsUnderTests(page.getSpaceKey(), page.getTitle());
            for (SystemUnderTest sut : suts) {
                if (selectedSut != null && selectedSut.equalsTo((Object)sut)) {
                    return this.buildSelectedSystemUnderTestInfo(selectedSut);
                }
                if (!sut.isDefault()) continue;
                defaultSut = sut;
            }
            if (defaultSut == null && !suts.isEmpty()) {
                defaultSut = suts.iterator().next();
            }
        }
        catch (GreenPepperServerException e) {
            // empty catch block
        }
        String key = this.buildSelectedSystemUnderTestInfo(defaultSut);
        this.saveSelectedSystemUnderTestInfo(page, key);
        return key;
    }

    public SystemUnderTest getSelectedSystemUnderTest(Page page) {
        return this.buildSelectedSystemUnderTest(this.getSelectedSystemUnderTestInfo(page));
    }

    public void saveSelectedSystemUnderTestInfo(Page page, String value) {
        ContentEntityObject entityObject = this.getContentEntityManager().getById(page.getId());
        this.getContentPropertyManager().setStringProperty(entityObject, EXECUTION_KEY, value);
    }

    public void revertImplementation(Page page) {
        Integer previousImplementedVersion = this.getPreviousImplementedVersion(page);
        if (previousImplementedVersion != null) {
            this.saveImplementedVersion(page, previousImplementedVersion);
            this.savePreviousImplementedVersion(page, null);
        }
    }

    public Integer getPreviousImplementedVersion(Page page) {
        ContentEntityObject entityObject = this.getContentEntityManager().getById(page.getId());
        String value = this.getContentPropertyManager().getStringProperty(entityObject, PREVIOUS_IMPLEMENTED_VERSION);
        return value == null ? null : Integer.valueOf(value);
    }

    public void savePreviousImplementedVersion(Page page, Integer version) {
        String value = version != null ? String.valueOf(version) : null;
        ContentEntityObject entityObject = this.getContentEntityManager().getById(page.getId());
        this.getContentPropertyManager().setStringProperty(entityObject, PREVIOUS_IMPLEMENTED_VERSION, value);
    }

    public boolean canBeImplemented(Page page) {
        Integer implementedVersion = this.getImplementedVersion(page);
        return implementedVersion == null || page.getVersion() != implementedVersion.intValue();
    }

    public Integer getImplementedVersion(Page page) {
        ContentEntityObject entityObject = this.getContentEntityManager().getById(page.getId());
        String value = this.getContentPropertyManager().getStringProperty(entityObject, IMPLEMENTED_VERSION);
        return value == null ? null : Integer.valueOf(value);
    }

    public void saveImplementedVersion(Page page, Integer version) {
        Integer previousImplementedVersion = this.getImplementedVersion(page);
        if (previousImplementedVersion != null && version != null && previousImplementedVersion == version) {
            return;
        }
        if (previousImplementedVersion != null) {
            this.savePreviousImplementedVersion(page, previousImplementedVersion);
        }
        String value = version != null ? String.valueOf(version) : null;
        ContentEntityObject entityObject = this.getContentEntityManager().getById(page.getId());
        this.getContentPropertyManager().setStringProperty(entityObject, IMPLEMENTED_VERSION, value);
    }

    public AbstractPage getImplementedPage(Page page) throws GreenPepperServerException {
        Integer version = this.getImplementedVersion(page);
        if (version == null) {
            throw new GreenPepperServerException(NEVER_IMPLEMENTED, "Never Implemented");
        }
        return this.getPageManager().getPageByVersion((AbstractPage)page, version.intValue());
    }

    public boolean isImplementationDue(Page page) {
        Date date;
        Period period;
        int version = page.getVersion();
        Integer implementedVersion = this.getImplementedVersion(page);
        if (implementedVersion != null) {
            version = page.getVersion() == implementedVersion.intValue() ? implementedVersion : implementedVersion + 1;
        }
        return (period = Period.fromTo((Date)(date = this.getPageManager().getPageByVersion((AbstractPage)page, version).getLastModificationDate()), (Date)new Date(System.currentTimeMillis()))).daysCount() > 29;
    }

    public boolean getExecuteChildren(Page page) {
        ContentEntityObject entityObject = this.getContentEntityManager().getById(page.getId());
        String value = this.getContentPropertyManager().getStringProperty(entityObject, EXECUTE_CHILDREN);
        return value == null ? false : Boolean.valueOf(value);
    }

    public void saveExecuteChildren(Page page, Boolean doExecuteChildren) {
        ContentEntityObject entityObject = this.getContentEntityManager().getById(page.getId());
        this.getContentPropertyManager().setStringProperty(entityObject, EXECUTE_CHILDREN, doExecuteChildren != null ? String.valueOf(doExecuteChildren) : null);
    }

    public boolean isSelected(String selectedSystemUnderTestInfo, String key) {
        return selectedSystemUnderTestInfo != null ? selectedSystemUnderTestInfo.equals(key) : false;
    }

    public String getBaseUrl() {
        return this.getSettingsManager().getGlobalSettings().getBaseUrl();
    }

    public String getEncoding() {
        return this.getSettingsManager().getGlobalSettings().getDefaultEncoding();
    }

    public String getPageUrl(Page page) {
        return this.getBaseUrl() + page.getUrlPath();
    }

    public boolean canEdit(Page page) {
        ArrayList<String> permTypes = new ArrayList<String>();
        permTypes.add("EDITSPACE");
        return this.getSpacePermissionManager().hasPermissionForSpace(this.getRemoteUser(), permTypes, page.getSpace());
    }

    public boolean canView(Page page) {
        return this.canView(page.getSpace());
    }

    public boolean canView(Space space) {
        ArrayList<String> permTypes = new ArrayList<String>();
        permTypes.add("VIEWSPACE");
        return this.getSpacePermissionManager().hasPermissionForSpace(this.getRemoteUser(), permTypes, space);
    }

    public String getHeader() {
        return "/templates/greenpepper/confluence/themes/greenpepper-header.vm";
    }

    public String getBody() {
        return "templates/greenpepper/confluence/themes/greenpepper-body.vm";
    }

    public boolean isInSutList(SystemUnderTest sut, Collection<SystemUnderTest> sutList) {
        for (SystemUnderTest aSut : sutList) {
            if (!aSut.equalsTo((Object)sut)) continue;
            return true;
        }
        return false;
    }

    public static String clean(String text) {
        if (text == null) {
            return "";
        }
        text = text.trim();
        text = text.replace("\"", "\\\"");
        text = text.replace("'", "\\'");
        text = text.replace("\n", "");
        text = text.replace("\r", "");
        return text;
    }

    public User getRemoteUser() {
        String remoteUserName;
        HttpServletRequest request = ServletActionContext.getRequest();
        if (request != null && (remoteUserName = request.getRemoteUser()) != null) {
            return this.getUserAccessor().getUserIfAvailable(remoteUserName);
        }
        return AuthenticatedUserThreadLocal.getUser();
    }

    public String getPageProperty(String key, String identifier) {
        Space space = this.getSpaceManager().getSpace(identifier);
        if (space == null) {
            return null;
        }
        ContentEntityObject entityObject = this.getContentEntityManager().getById(space.getHomePage().getId());
        return this.getContentPropertyManager().getStringProperty(entityObject, "greenpepper." + key);
    }

    public void setPageProperty(String key, String value, String identifier) {
        Space space = this.getSpaceManager().getSpace(identifier);
        ContentEntityObject entityObject = this.getContentEntityManager().getById(space.getHomePage().getId());
        this.getContentPropertyManager().setStringProperty(entityObject, "greenpepper." + key, value);
    }

    public GreenPepperServerConfiguration getGPServerConfiguration() {
        return this.getGPServerConfigurationActivator().getConfiguration();
    }

    public void storeGPServerConfiguration(GreenPepperServerConfiguration configuration) {
        this.getGPServerConfigurationActivator().storeConfiguration(configuration);
    }

    public boolean isServerSetupComplete() {
        return this.getGPServerConfiguration().isSetupComplete();
    }

    public boolean isServerReady() {
        return this.getGPServerConfigurationActivator().isReady();
    }

    public void verifyCredentials(String username, String password) throws GreenPepperServerException {
        if (username != null && !this.isCredentialsValid(username, password)) {
            throw new GreenPepperServerException("greenpepper.confluence.badcredentials", "The username and password are incorrect.");
        }
    }

    public boolean isCredentialsValid(String username, String password) {
        try {
            String token = this.getTokenAuthenticationManager().login(StringUtil.toEmptyIfNull((String)username), StringUtil.toEmptyIfNull((String)password));
            this.getTokenAuthenticationManager().logout(token);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public DateFormatter getUserPreferencesDateFormatter() {
        ConfluenceUserPreferences preferences = this.getUserAccessor().getConfluenceUserPreferences(this.getRemoteUser());
        return preferences.getDateFormatter(this.getFormatSettingsManager());
    }

    public GreenPepperServerService getGPServerService() {
        if (this.service != null) {
            return this.service;
        }
        this.service = (GreenPepperServerService)ContainerManager.getComponent((String)"greenPepperServerService");
        return this.service;
    }

    public SettingsManager getSettingsManager() {
        if (this.settingsManager != null) {
            return this.settingsManager;
        }
        this.settingsManager = (SettingsManager)ContainerManager.getComponent((String)"settingsManager");
        return this.settingsManager;
    }

    public AtlassianBootstrapManager getBootstrapManager() {
        if (this.bootstrapManager != null) {
            return this.bootstrapManager;
        }
        this.bootstrapManager = BootstrapUtils.getBootstrapManager();
        return this.bootstrapManager;
    }

    public ContentPermissionManager getContentPermissionManager() {
        if (this.contentPermissionManager != null) {
            return this.contentPermissionManager;
        }
        this.contentPermissionManager = (ContentPermissionManager)ContainerManager.getComponent((String)"contentPermissionManager");
        return this.contentPermissionManager;
    }

    public ContentPropertyManager getContentPropertyManager() {
        if (this.contentPropertyManager != null) {
            return this.contentPropertyManager;
        }
        this.contentPropertyManager = (ContentPropertyManager)ContainerManager.getComponent((String)"contentPropertyManager");
        return this.contentPropertyManager;
    }

    public ContentEntityManager getContentEntityManager() {
        if (this.contentEntityManager != null) {
            return this.contentEntityManager;
        }
        this.contentEntityManager = (ContentEntityManager)ContainerManager.getComponent((String)"contentEntityManager");
        return this.contentEntityManager;
    }

    public WikiStyleRenderer getWikiStyleRenderer() {
        if (this.wikiStyleRenderer != null) {
            return this.wikiStyleRenderer;
        }
        this.wikiStyleRenderer = (WikiStyleRenderer)ContainerManager.getComponent((String)"wikiStyleRenderer");
        return this.wikiStyleRenderer;
    }

    public Renderer getViewRenderer() {
        if (this.viewRenderer != null) {
            return this.viewRenderer;
        }
        this.viewRenderer = (Renderer)ContainerManager.getComponent((String)"viewRenderer");
        return this.viewRenderer;
    }

    public BodyTypeAwareRenderer getBodyTypeAwareRenderer() {
        if (this.bodyTypeAwareRenderer != null) {
            return this.bodyTypeAwareRenderer;
        }
        this.bodyTypeAwareRenderer = new BodyTypeAwareRenderer(this.getViewRenderer(), this.getWikiStyleRenderer());
        return this.bodyTypeAwareRenderer;
    }

    public PageManager getPageManager() {
        if (this.pageManager != null) {
            return this.pageManager;
        }
        this.pageManager = (PageManager)ContainerManager.getComponent((String)"pageManager");
        return this.pageManager;
    }

    public SpaceManager getSpaceManager() {
        if (this.spaceManager != null) {
            return this.spaceManager;
        }
        this.spaceManager = (SpaceManager)ContainerManager.getComponent((String)"spaceManager");
        return this.spaceManager;
    }

    public SpacePermissionManager getSpacePermissionManager() {
        if (this.spacePermissionManager != null) {
            return this.spacePermissionManager;
        }
        this.spacePermissionManager = (SpacePermissionManager)ContainerManager.getComponent((String)"spacePermissionManager");
        return this.spacePermissionManager;
    }

    public LabelManager getLabelManager() {
        if (this.labelManager != null) {
            return this.labelManager;
        }
        this.labelManager = (LabelManager)ContainerManager.getComponent((String)"labelManager");
        return this.labelManager;
    }

    public TokenAuthenticationManager getTokenAuthenticationManager() {
        if (this.tokenManager != null) {
            return this.tokenManager;
        }
        this.tokenManager = (TokenAuthenticationManager)ContainerManager.getComponent((String)"tokenAuthenticationManager");
        return this.tokenManager;
    }

    public PlatformTransactionManager getPlatformTransactionManager() {
        if (this.transactionManager != null) {
            return this.transactionManager;
        }
        this.transactionManager = (PlatformTransactionManager)ContainerManager.getComponent((String)"transactionManager");
        return this.transactionManager;
    }

    public UserAccessor getUserAccessor() {
        if (this.userAccessor != null) {
            return this.userAccessor;
        }
        this.userAccessor = (UserAccessor)ContainerManager.getComponent((String)"userAccessor");
        return this.userAccessor;
    }

    public GreenPepperServerConfigurationActivator getGPServerConfigurationActivator() {
        if (this.configurationActivator != null) {
            return this.configurationActivator;
        }
        this.configurationActivator = (GreenPepperServerConfigurationActivator)ContainerManager.getComponent((String)"greenPepperServerConfigurationActivator");
        return this.configurationActivator;
    }

    public GreenPepperUserGroup getGreenPepperUserGroup() {
        if (this.gpUserGroup != null) {
            return this.gpUserGroup;
        }
        this.gpUserGroup = new GreenPepperUserGroup();
        return this.gpUserGroup;
    }

    public FormatSettingsManager getFormatSettingsManager() {
        if (this.formatSettingsManager != null) {
            return this.formatSettingsManager;
        }
        this.formatSettingsManager = (FormatSettingsManager)ContainerManager.getComponent((String)"formatSettingsManager");
        return this.formatSettingsManager;
    }

    private String buildSelectedSystemUnderTestInfo(SystemUnderTest sut) {
        return sut.getProject().getName() + "@" + sut.getName();
    }

    private SystemUnderTest getSavedSelectedSystemUnderTest(Page page) {
        ContentEntityObject entityObject = this.getContentEntityManager().getById(page.getId());
        String key = this.getContentPropertyManager().getStringProperty(entityObject, EXECUTION_KEY);
        return this.buildSelectedSystemUnderTest(key);
    }

    private SystemUnderTest buildSelectedSystemUnderTest(String selectedSystemUnderTestInfo) {
        if (StringUtil.isBlank((String)selectedSystemUnderTestInfo)) {
            return null;
        }
        StringTokenizer stk = new StringTokenizer(selectedSystemUnderTestInfo, "@");
        Project project = Project.newInstance((String)stk.nextToken());
        SystemUnderTest sut = SystemUnderTest.newInstance((String)stk.nextToken());
        sut.setProject(project);
        return sut;
    }

    private List<Reference> getUniqueReferences(List<Reference> references) {
        HashMap<String, Reference> uniqueReferences = new HashMap<String, Reference>();
        for (Reference reference : references) {
            Reference ref = (Reference)uniqueReferences.get(reference.getRequirement().getUUID());
            if (ref != null) continue;
            uniqueReferences.put(reference.getRequirement().getUUID(), reference);
        }
        return new ArrayList<Reference>(uniqueReferences.values());
    }

    public void saveExecutionResult(Page page, String sut, XmlReport xmlReport) throws GreenPepperServerException {
        Specification specification = this.getSpecification(page);
        List<SystemUnderTest> systemUnderTests = this.getSystemsUnderTests(page.getSpaceKey());
        SystemUnderTest systemUnderTest = null;
        for (SystemUnderTest s : systemUnderTests) {
            if (!s.getName().equals(sut)) continue;
            systemUnderTest = s;
            break;
        }
        if (systemUnderTest == null) {
            throw new GreenPepperServerException("greenpepper.server.sutnotfound", sut);
        }
        this.getGPServerService().createExecution(systemUnderTest, specification, xmlReport);
    }

    public boolean isPluginInstalledUnderWebInfLib() {
        URL root = this.getClass().getResource("/templates/greenpepper/confluence/blank.vm");
        return root.toExternalForm().indexOf("WEB-INF/lib/greenpepper-confluence5-plugin") != -1;
    }

    public String getWebInfLibDirectory() {
        String realPath = ServletActionContext.getServletContext().getRealPath("WEB-INF/lib");
        try {
            return new File(realPath).getCanonicalPath();
        }
        catch (IOException e) {
            return new File(realPath).getAbsolutePath();
        }
    }
}

