/*
 * Decompiled with CFR 0.152.
 */
package com.greenpepper.confluence.actions.execution;

import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.pages.Page;
import com.greenpepper.confluence.actions.execution.AbstractListExecutionAction;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class LabelExecutionAction
extends AbstractListExecutionAction {
    private String labels;
    private boolean searchQuery;

    @Override
    public void buildExecutableList() {
        for (String labelExp : this.labels.split(",")) {
            List<Page> pages = this.getExpLabeledPages(labelExp);
            for (Page page : pages) {
                if (!page.getSpaceKey().equals(this.spaceKey) || this.executableList.contains(page) || !this.gpUtil.isExecutable(page)) continue;
                this.executableList.add(page);
            }
        }
    }

    public String getLabels() {
        return this.labels;
    }

    public void setLabels(String labels) {
        this.labels = labels.replaceAll("&amp;", "&");
    }

    public boolean getSearchQuery() {
        return this.searchQuery;
    }

    public void setSearchQuery(boolean searchQuery) {
        this.searchQuery = searchQuery;
    }

    private List<Page> getExpLabeledPages(String labelExp) {
        StringTokenizer stk = new StringTokenizer(labelExp, "&");
        int tokens = stk.countTokens();
        if (tokens <= 1) {
            return this.getLabeledPages(labelExp.trim());
        }
        List<Page> pages = this.getLabeledPages(stk.nextToken().trim());
        for (int i = 1; i < tokens; ++i) {
            pages.retainAll(this.getLabeledPages(stk.nextToken().trim()));
        }
        return pages;
    }

    private List<Page> getLabeledPages(String label) {
        Label labelObject = this.gpUtil.getLabelManager().getLabel(label.trim());
        if (labelObject != null) {
            return this.gpUtil.getLabelManager().getContent(labelObject);
        }
        return new ArrayList<Page>();
    }
}

