/*
 * Decompiled with CFR 0.152.
 */
package com.greenpepper.confluence.actions.execution;

import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.greenpepper.confluence.actions.AbstractGreenPepperAction;
import com.greenpepper.confluence.utils.stylesheet.StyleSheetExtractorFactory;
import com.greenpepper.server.GreenPepperServerException;
import com.greenpepper.server.domain.Execution;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class ShowExecutionResultAction
extends AbstractGreenPepperAction {
    private Long id;
    private Execution execution;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Execution getExecution() {
        return this.execution;
    }

    public void setExecution(Execution execution) {
        this.execution = execution;
    }

    @HtmlSafe
    public String getTitleHtml() {
        return this.getTitle(false);
    }

    @HtmlSafe
    public String getTitleWithAnchorHtml() {
        return this.getTitle(true);
    }

    private String getTitle(boolean useAnchor) {
        if (this.execution == null) {
            return "";
        }
        StringBuilder title = new StringBuilder();
        title.append(useAnchor ? this.getTitleAnchor() : this.execution.getSpecification().getName()).append(' ').append(this.gpUtil.getText("greenpepper.execution.for")).append(' ').append(this.gpUtil.getText("greenpepper.execution.openbraket")).append(this.execution.getSystemUnderTest().getName()).append(' ').append(this.gpUtil.getText("greenpepper.execution.closebraket")).append(" - ").append(this.getDateFormatter().formatDateTime((Date)this.execution.getExecutionDate()));
        return title.toString();
    }

    private String getTitleAnchor() {
        String resolvedName = null;
        try {
            resolvedName = this.execution.getSpecification().getResolvedName();
        }
        catch (GreenPepperServerException greenPepperServerException) {
            // empty catch block
        }
        return resolvedName == null ? this.execution.getSpecification().getName() : String.format("<a href=\"%s\" alt=\"\">%s</a>", resolvedName, this.execution.getSpecification().getName());
    }

    @HtmlSafe
    public String getStylesheetHtml() {
        Space space = this.gpUtil.getSpaceManager().getSpace(this.getSpaceKey());
        return String.format("<style>\n%s\n</style>\n<base href=\"%s\"/>\n", StyleSheetExtractorFactory.getInstance().renderStyleSheet(space), this.gpUtil.getBaseUrl());
    }

    public boolean getHasException() {
        return this.execution != null && this.execution.hasException();
    }

    @HtmlSafe
    public String getExceptionHtml() {
        return this.execution.getExecutionErrorId();
    }

    public boolean getHasBody() {
        return this.execution != null && StringUtils.isNotEmpty((String)this.execution.getResults());
    }

    @HtmlSafe
    public String getBodyHtml() {
        String body = this.execution.getResults().trim();
        return body.replaceAll("<html>", "").replaceAll("</html>", "");
    }

    public boolean getHasSections() {
        return this.execution != null && StringUtils.isNotEmpty((String)this.execution.getSections());
    }

    @HtmlSafe
    public String getSectionsHtml() {
        return String.format("%s : %s", this.gpUtil.getText("greenpepper.page.sections"), this.execution.getSections());
    }

    public String show() {
        try {
            this.execution = this.gpUtil.getGPServerService().getSpecificationExecution(this.getId());
        }
        catch (GreenPepperServerException e) {
            this.addActionError(e.getId());
        }
        return "success";
    }
}

