/*
 * Decompiled with CFR 0.152.
 */
package com.greenpepper.confluence.actions.server;

import com.atlassian.confluence.spaces.actions.AbstractSpaceAction;
import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import com.greenpepper.confluence.actions.server.ConfigurationAction;
import com.greenpepper.confluence.velocity.ConfluenceGreenPepper;
import com.greenpepper.server.GreenPepperServerException;
import com.greenpepper.server.GreenPepperServerService;
import com.greenpepper.server.domain.Project;
import com.greenpepper.server.domain.Repository;
import com.greenpepper.server.domain.SystemUnderTest;
import com.greenpepper.util.I18nUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class GreenPepperServerAction
extends AbstractSpaceAction {
    private static final String RESOURCE_BUNDLE = ConfigurationAction.class.getName();
    private final ThreadLocal<Locale> threadLocale = new ThreadLocal();
    private ResourceBundle resourceBundle;
    protected ConfluenceGreenPepper gpUtil = new ConfluenceGreenPepper();
    private List<SystemUnderTest> systemUnderTests;
    protected String projectName;
    protected Repository registeredRepository;
    protected Repository homeRepository;
    private String spaceKey;
    private String url;
    private String handler = "greenpepper1";
    private Boolean isRegistered;
    protected LinkedList<Project> projects;

    protected GreenPepperServerService getService() {
        return this.gpUtil.getGPServerService();
    }

    public boolean isPluginInstalledUnderWebInfLib() {
        return this.gpUtil.isPluginInstalledUnderWebInfLib();
    }

    public boolean isServerSetupComplete() {
        return this.gpUtil.isServerSetupComplete();
    }

    public boolean isServerReady() {
        return this.gpUtil.isServerReady();
    }

    public boolean getIsServerReady() {
        return this.isServerReady();
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName.trim();
    }

    public String getUrl() {
        if (this.url != null) {
            return this.url;
        }
        this.url = this.getNotNullProperty("GREENPEPPER_URL");
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url.trim();
    }

    public String getHandler() {
        return this.handler;
    }

    public void setHandler(String handler) {
        this.handler = handler.trim();
    }

    public String getIdentifier() {
        return this.key;
    }

    public Repository getRegisteredRepository() throws GreenPepperServerException {
        if (this.registeredRepository != null) {
            return this.registeredRepository;
        }
        this.registeredRepository = this.getService().getRegisteredRepository(this.getHomeRepository());
        return this.registeredRepository;
    }

    public void setRegisteredRepository(Repository registeredRepository) {
        this.registeredRepository = registeredRepository;
    }

    public Repository getHomeRepository() throws GreenPepperServerException {
        if (this.homeRepository != null) {
            return this.homeRepository;
        }
        this.homeRepository = this.key == null ? Repository.newInstance((String)"UNKNOWN_UID") : this.gpUtil.getHomeRepository(this.key);
        return this.homeRepository;
    }

    public List<SystemUnderTest> getSystemUnderTests() {
        try {
            if (this.projectName == null && this.systemUnderTests != null) {
                return this.systemUnderTests;
            }
            this.systemUnderTests = this.gpUtil.getGPServerService().getSystemUnderTestsOfProject(this.projectName);
        }
        catch (GreenPepperServerException e) {
            this.addActionError(e.getId());
        }
        return this.systemUnderTests;
    }

    public boolean isRegistered() {
        if (this.isRegistered != null) {
            return this.isRegistered;
        }
        if (!this.isServerReady()) {
            return false;
        }
        try {
            this.getRegisteredRepository();
            this.isRegistered = true;
        }
        catch (GreenPepperServerException e) {
            this.isRegistered = false;
        }
        return this.isRegistered;
    }

    public boolean getCanConnect() {
        return this.isServerReady();
    }

    public boolean isWithNewProject() {
        return this.projectName != null && this.projectName.equals(this.projectCreateOption());
    }

    public String getUID(SystemUnderTest sut) {
        return sut.getName().replaceAll(" ", "_");
    }

    protected String projectCreateOption() {
        return this.getText("greenpepper.registration.newproject");
    }

    private String getNotNullProperty(String key) {
        String value = this.gpUtil.getPageProperty(key, this.getIdentifier());
        return value == null ? "" : value;
    }

    public String getSpaceKey() {
        if (this.spaceKey == null) {
            this.spaceKey = this.key;
        }
        return this.spaceKey;
    }

    public void setSpaceKey(String spaceKey) {
        this.key = spaceKey;
        this.spaceKey = spaceKey;
    }

    @HtmlSafe
    public String getText(String key) {
        String text = super.getText(key);
        if (text.equals(key)) {
            text = I18nUtil.getText((String)key, (ResourceBundle)this.getResourceBundle());
        }
        return text;
    }

    @HtmlSafe
    public String getText(String key, Object[] args) {
        String text = super.getText(key, args);
        if (text.equals(key)) {
            text = I18nUtil.getText((String)key, (ResourceBundle)this.getResourceBundle(), (Object[])args);
        }
        return text;
    }

    private ResourceBundle getResourceBundle() {
        if (this.resourceBundle == null) {
            Locale locale = this.threadLocale.get();
            if (locale == null) {
                locale = this.getLocale();
                this.threadLocale.set(locale == null ? Locale.ENGLISH : locale);
            }
            this.resourceBundle = ResourceBundle.getBundle(RESOURCE_BUNDLE, locale);
        }
        return this.resourceBundle;
    }

    public LinkedList<Project> getProjects() {
        if (this.projects != null) {
            return this.projects;
        }
        try {
            this.projects = new LinkedList(this.getService().getAllProjects());
            this.projectName = this.projectName == null ? ((Project)this.projects.iterator().next()).getName() : this.projectName;
            return this.projects;
        }
        catch (GreenPepperServerException e) {
            this.addActionError(e.getId());
            return this.projects;
        }
    }
}

