/*
 * Decompiled with CFR 0.152.
 */
package com.greenpepper.confluence.macros;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.greenpepper.confluence.actions.execution.LabelExecutionAction;
import com.greenpepper.confluence.macros.AbstractGreenPepperMacro;
import com.greenpepper.confluence.macros.historic.AbstractChartBuilder;
import com.greenpepper.confluence.macros.historic.AggregationExecutionChartBuilder;
import com.greenpepper.confluence.macros.historic.HistoricParameters;
import com.greenpepper.confluence.macros.historic.LinearExecutionChartBuilder;
import com.greenpepper.confluence.utils.MacroCounter;
import com.greenpepper.server.GreenPepperServerException;
import com.greenpepper.server.domain.Execution;
import com.greenpepper.server.domain.Specification;
import com.greenpepper.server.domain.SystemUnderTest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;

public class GreenPepperHistoric
extends AbstractGreenPepperMacro {
    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        try {
            AbstractChartBuilder chartBuilder;
            Map contextMap = MacroUtils.defaultVelocityContext();
            String spaceKey = this.getSpaceKey(parameters, renderContext, false);
            Page page = this.getPage(parameters, renderContext, spaceKey);
            String executionUID = "GP_HISTORIC_" + MacroCounter.instance().getNextCount();
            HistoricParameters settings = new HistoricParameters(parameters, spaceKey, page, executionUID);
            if (settings.getLabels() == null && settings.isNoChildren()) {
                Specification specification = this.gpUtil.getSpecification(page.getSpaceKey(), page.getTitle().trim());
                List executions = this.gpUtil.getGPServerService().getSpecificationExecutions(specification, settings.getTargetedSystemUnderTest(), settings.getMaxResult());
                chartBuilder = LinearExecutionChartBuilder.newInstance(settings, executions);
            } else {
                ArrayList<Specification> specifications = new ArrayList<Specification>();
                if (!settings.isNoChildren()) {
                    List<Specification> specificationsChildren = this.getTargetSpecificationsChildren(page, settings.getSut(), settings.isAllChildren());
                    specifications.addAll(specificationsChildren);
                }
                if (settings.getLabels() != null) {
                    List<Specification> specificationsWithLabel = this.getTargetSpecificationsLabels(settings.getSpaceKey(), settings.getSut(), settings.getLabels());
                    if (settings.isNoChildren()) {
                        specifications.addAll(specificationsWithLabel);
                    } else {
                        specifications.retainAll(specificationsWithLabel);
                    }
                }
                List<Execution> executions = this.aggregateExecutions(specifications, settings.getTargetedSystemUnderTest(), settings.getMaxResult());
                chartBuilder = AggregationExecutionChartBuilder.newInstance(settings, executions);
            }
            String chartMapId = executionUID + "_map";
            contextMap.put("executionUID", executionUID);
            contextMap.put("chartImage", chartBuilder.generateChart());
            contextMap.put("settings", settings);
            contextMap.put("chartMapHtml", chartBuilder.getChartMap(chartMapId));
            contextMap.put("chartMapId", "#" + chartMapId);
            return VelocityUtils.getRenderedTemplate((String)"/templates/greenpepper/confluence/macros/greenPepperHistoric.vm", (Map)contextMap);
        }
        catch (GreenPepperServerException gpe) {
            return GreenPepperHistoric.getErrorView("greenpepper.historic.macroid", gpe.getId());
        }
        catch (Exception e) {
            return GreenPepperHistoric.getErrorView("greenpepper.historic.macroid", e.getMessage());
        }
    }

    private List<Specification> getTargetSpecificationsChildren(final Page page, String sut, boolean allChildren) throws GreenPepperServerException {
        ArrayList<Page> pages = new ArrayList<Page>(){
            {
                this.add(page);
            }
        };
        this.fillChildrenPages(page, allChildren, (List<Page>)pages);
        return this.getSpecificationsFromPages(sut, (List<Page>)pages);
    }

    private boolean isSpecificationAssociatedToSut(Specification specification, String systemUnderTest) {
        SortedSet suts = specification.getTargetedSystemUnderTests();
        for (SystemUnderTest sut : suts) {
            if (!sut.getName().equals(systemUnderTest)) continue;
            return true;
        }
        return false;
    }

    private void fillChildrenPages(Page page, boolean allChildren, List<Page> childrens) {
        List pageChildren = this.gpUtil.getContentPermissionManager().getPermittedChildren(page, this.gpUtil.getRemoteUser());
        for (Page child : pageChildren) {
            if (this.gpUtil.isExecutable(child)) {
                childrens.add(child);
            }
            if (!allChildren) continue;
            this.fillChildrenPages(child, allChildren, childrens);
        }
    }

    private List<Specification> getTargetSpecificationsLabels(String spaceKey, String sut, String labels) throws GreenPepperServerException {
        LabelExecutionAction action = new LabelExecutionAction();
        action.setSpaceKey(spaceKey);
        action.setLabels(labels);
        action.setForcedSuts(sut);
        LinkedList<Page> pages = action.getExecutableList();
        return this.getSpecificationsFromPages(sut, pages);
    }

    private void sort(List<Specification> specifications) {
        Collections.sort(specifications, new Comparator<Specification>(){

            @Override
            public int compare(Specification o1, Specification o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
    }

    protected List<Specification> getSpecificationsFromPages(String sut, List<Page> pages) throws GreenPepperServerException {
        ArrayList<Specification> specifications = new ArrayList<Specification>();
        for (Page childPage : pages) {
            Specification specification = this.gpUtil.getSpecification(childPage);
            if (specification == null || !this.isSpecificationAssociatedToSut(specification, sut)) continue;
            specifications.add(specification);
        }
        this.sort(specifications);
        return specifications;
    }

    private List<Execution> aggregateExecutions(List<Specification> specifications, SystemUnderTest targetedSystemUnderTest, int maxResult) throws GreenPepperServerException {
        ArrayList<Execution> executions = new ArrayList<Execution>();
        for (Specification specification : specifications) {
            List execs = this.gpUtil.getGPServerService().getSpecificationExecutions(specification, targetedSystemUnderTest, maxResult);
            int failureCount = 0;
            int errorCount = 0;
            int ignoredCount = 0;
            int successCount = 0;
            for (Execution exec : execs) {
                failureCount += exec.getFailures();
                errorCount += exec.getErrors() + (exec.hasException() ? 1 : 0);
                ignoredCount += exec.getIgnored();
                successCount += exec.getSuccess();
            }
            Execution execution = new Execution();
            execution.setErrors(errorCount);
            execution.setFailures(failureCount);
            execution.setIgnored(ignoredCount);
            execution.setSuccess(successCount);
            execution.setSpecification(specification);
            execution.setId(specification.getId());
            executions.add(execution);
        }
        return executions;
    }
}

