/*
 * Decompiled with CFR 0.152.
 */
package com.greenpepper.confluence.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.greenpepper.confluence.macros.AbstractGreenPepperMacro;
import com.greenpepper.confluence.utils.MacroParametersUtils;
import com.greenpepper.confluence.velocity.ConfluenceGreenPepper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class GreenPepperImport
extends AbstractGreenPepperMacro {
    public static final String IMPORTS_PARAM = "imports";

    @Override
    public Macro.BodyType getBodyType() {
        return Macro.BodyType.PLAIN_TEXT;
    }

    @Override
    public String execute(Map<String, String> parameters, String body, ConversionContext context) throws MacroExecutionException {
        String[] imports = StringUtils.split((String)body, (char)'\n');
        List<String> importList = Arrays.asList(imports);
        importList.addAll(this.getImportList(parameters));
        return this.executeMacro(importList);
    }

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        List<String> importList = this.getImportList(parameters);
        return this.executeMacro(importList);
    }

    private String executeMacro(Collection<String> importList) {
        try {
            Map contextMap = MacroUtils.defaultVelocityContext();
            contextMap.put(IMPORTS_PARAM, importList);
            return VelocityUtils.getRenderedTemplate((String)"/templates/greenpepper/confluence/macros/greenPepperImport.vm", (Map)contextMap);
        }
        catch (Exception e) {
            return GreenPepperImport.getErrorView("greenpepper.import.macroid", e.getMessage());
        }
    }

    public static String getErrorView(String macroId, String errorId) {
        Map contextMap = MacroUtils.defaultVelocityContext();
        contextMap.put("macroId", macroId);
        contextMap.put("errorId", errorId);
        return VelocityUtils.getRenderedTemplate((String)"/templates/greenpepper/confluence/macros/greenPepperMacros-error.vm", (Map)contextMap);
    }

    private List<String> getImportList(Map<String, String> parameters) {
        String[] values;
        ArrayList<String> imports = new ArrayList<String>();
        int index = 0;
        String importParam = parameters.get(String.valueOf(index));
        while (importParam != null) {
            imports.add(ConfluenceGreenPepper.clean(importParam));
            importParam = parameters.get(String.valueOf(++index));
        }
        for (String value : values = MacroParametersUtils.extractParameterMultiple(IMPORTS_PARAM, parameters)) {
            if (value == null) continue;
            imports.add(ConfluenceGreenPepper.clean(value));
        }
        return imports;
    }
}

