/*
 * Decompiled with CFR 0.152.
 */
package com.greenpepper.confluence.macros;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.macro.MacroException;
import com.greenpepper.confluence.macros.AbstractGreenPepperMacro;
import com.greenpepper.confluence.utils.MacroCounter;
import com.greenpepper.server.GreenPepperServerException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class GreenPepperInclude
extends AbstractGreenPepperMacro {
    private static final String INCLUDED_PAGE_PARAM_NAME = "gp$included";

    @Override
    public boolean isInline() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        PageContext context = (PageContext)renderContext;
        boolean isRoot = this.getIncludedPagesParam(context) == null;
        try {
            String string;
            this.checkMandatoryPageTitleParameter(parameters);
            String spaceKey = this.getSpaceKey(parameters, renderContext, false);
            String pageTitle = this.getPageTitle(parameters, renderContext, spaceKey);
            Page owner = (Page)context.getEntity();
            Page page = this.gpUtil.getPageManager().getPage(spaceKey, pageTitle);
            List<Page> includedPages = this.getSafeIncludedPagesParam(context, owner);
            if (includedPages.contains(page)) {
                throw new GreenPepperServerException("greenpepper.include.recursivitydetection", "");
            }
            try {
                includedPages.add(page);
                string = this.render(parameters, context, pageTitle, page);
                includedPages.remove(page);
            }
            catch (Throwable throwable) {
                String string2;
                try {
                    includedPages.remove(page);
                    throw throwable;
                }
                catch (GreenPepperServerException gpe) {
                    string2 = GreenPepperInclude.getErrorView("greenpepper.include.macroid", gpe.getId(), gpe.getLocalizedMessage());
                    return string2;
                }
                catch (Exception e) {
                    string2 = GreenPepperInclude.getErrorView("greenpepper.include.macroid", e.getMessage());
                    return string2;
                }
            }
            return string;
        }
        finally {
            if (isRoot) {
                this.cleanIncludedPagesParam(context);
            }
        }
    }

    private void checkMandatoryPageTitleParameter(Map parameters) throws GreenPepperServerException {
        if (!parameters.containsKey("pageTitle")) {
            throw new GreenPepperServerException("greenpepper.children.pagenotfound", "");
        }
    }

    private List<Page> getIncludedPagesParam(PageContext context) {
        return (List)context.getParam((Object)INCLUDED_PAGE_PARAM_NAME);
    }

    private List<Page> getSafeIncludedPagesParam(PageContext context, Page owner) {
        List<Page> pages = this.getIncludedPagesParam(context);
        if (pages == null) {
            pages = new ArrayList<Page>();
            pages.add(owner);
            context.addParam((Object)INCLUDED_PAGE_PARAM_NAME, pages);
        }
        return pages;
    }

    private String render(Map parameters, PageContext context, String pageTitle, Page page) {
        Map contextMap = MacroUtils.defaultVelocityContext();
        String title = (String)parameters.get("title");
        contextMap.put("title", title != null ? title : pageTitle);
        contextMap.put("includeHtml", this.gpUtil.getViewRenderer().render((ContentEntityObject)page));
        contextMap.put("executionUID", "GP_INCLUDE_" + MacroCounter.instance().getNextCount());
        contextMap.put("expanded", this.isExpanded(parameters));
        return VelocityUtils.getRenderedTemplate((String)"/templates/greenpepper/confluence/macros/greenPepperInclude.vm", (Map)contextMap);
    }

    private void cleanIncludedPagesParam(PageContext context) {
        List<Page> pages = this.getIncludedPagesParam(context);
        if (pages != null) {
            pages.clear();
        }
        context.addParam((Object)INCLUDED_PAGE_PARAM_NAME, null);
    }
}

