/*
 * Decompiled with CFR 0.152.
 */
package com.greenpepper.confluence.macros.historic;

import com.atlassian.confluence.servlet.download.ExportDownload;
import com.greenpepper.confluence.macros.historic.HistoricParameters;
import com.greenpepper.confluence.velocity.ConfluenceGreenPepper;
import com.greenpepper.server.GreenPepperServerException;
import com.greenpepper.util.IOUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.imageio.ImageIO;
import org.apache.commons.lang.StringUtils;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.imagemap.StandardToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.StandardURLTagFragmentGenerator;
import org.jfree.chart.imagemap.ToolTipTagFragmentGenerator;
import org.jfree.chart.imagemap.URLTagFragmentGenerator;
import org.jfree.chart.title.TextTitle;
import org.jfree.chart.title.Title;
import org.jfree.ui.HorizontalAlignment;

public abstract class AbstractChartBuilder {
    protected static final String DEFAULT_FONT_NAME = "Helvetica";
    protected static final Font DEFAULT_TITLE_FONT = new Font("Helvetica", 1, 12);
    protected static final Font DEFAULT_SUBTITLE_FONT = new Font("Helvetica", 0, 11);
    protected static final Font DEFAULT_SUBTITLE2_FONT = new Font("Helvetica", 0, 11);
    protected static final Font DEFAULT_AXIS_FONT = new Font("Helvetica", 0, 10);
    protected static final Font DEFAULT_LABEL_FONT = new Font("Helvetica", 1, 10);
    protected static final Color TRANSPARENT_COLOR = new Color(0, 0, 0, 0);
    protected static final Color GREEN_COLOR = new Color(Integer.parseInt("33cc00", 16));
    private ChartRenderingInfo chartRenderingInfo = new ChartRenderingInfo();
    protected ConfluenceGreenPepper gpUtil = new ConfluenceGreenPepper();
    protected HistoricParameters settings;

    protected AbstractChartBuilder(HistoricParameters settings) {
        this.settings = settings;
    }

    public abstract String generateChart() throws GreenPepperServerException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getChartMap(String chartMapId) throws IOException {
        StringWriter writer = new StringWriter();
        PrintWriter pw = new PrintWriter(writer);
        try {
            ChartUtilities.writeImageMap((PrintWriter)pw, (String)chartMapId, (ChartRenderingInfo)this.chartRenderingInfo, (ToolTipTagFragmentGenerator)new StandardToolTipTagFragmentGenerator(), (URLTagFragmentGenerator)new StandardURLTagFragmentGenerator());
        }
        finally {
            IOUtil.closeQuietly((Closeable)pw);
        }
        return writer.toString();
    }

    protected String getDownloadPath(BufferedImage chartImage) throws IOException {
        File imageOutputFile = ExportDownload.createTempFile((String)"chart", (String)".png");
        ImageIO.write((RenderedImage)chartImage, "png", imageOutputFile);
        return ExportDownload.getUrl((File)imageOutputFile, (String)"image/png");
    }

    protected BufferedImage createChartImage(JFreeChart chart) {
        return chart.createBufferedImage(this.settings.getWidth(), this.settings.getHeight(), this.chartRenderingInfo);
    }

    protected void customizeTitle(TextTitle title, Font font) {
        title.setFont(font);
        title.setTextAlignment(HorizontalAlignment.LEFT);
        title.setPaint((Paint)Color.BLACK);
        title.setBackgroundPaint((Paint)TRANSPARENT_COLOR);
    }

    protected void customizeAxis(Axis axis) {
        axis.setLabelFont(DEFAULT_LABEL_FONT);
        axis.setTickLabelFont(DEFAULT_AXIS_FONT);
    }

    protected void addSubTitle(JFreeChart chart, String subTitle, Font font) {
        if (StringUtils.isNotEmpty((String)subTitle)) {
            TextTitle chartSubTitle = new TextTitle(subTitle);
            this.customizeTitle(chartSubTitle, font);
            chart.addSubtitle((Title)chartSubTitle);
        }
    }
}

