/*
 * Decompiled with CFR 0.152.
 */
package com.greenpepper.confluence.macros.migrator;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.definition.MacroBody;
import com.atlassian.confluence.content.render.xhtml.definition.PlainTextMacroBody;
import com.atlassian.confluence.macro.xhtml.MacroMigration;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreenPepperImportMigrator
implements MacroMigration {
    private static final Logger LOGGER = LoggerFactory.getLogger(GreenPepperImportMigrator.class);

    public MacroDefinition migrate(MacroDefinition macroDefinition, ConversionContext context) {
        LOGGER.debug("Beginning migration of macro {} ", (Object)macroDefinition);
        String imports = this.getV3Imports(macroDefinition);
        LOGGER.trace("Migrated Parameters to : {}", (Object)imports);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("imports", imports);
        MacroDefinition newMacroDefinition = new MacroDefinition();
        newMacroDefinition.setName(macroDefinition.getName());
        PlainTextMacroBody macroBody = new PlainTextMacroBody(imports.replaceAll(",", "\n"));
        newMacroDefinition.setBody((MacroBody)macroBody);
        LOGGER.debug("Migrated Macro: {}", (Object)newMacroDefinition);
        return newMacroDefinition;
    }

    private String getV3Imports(MacroDefinition macroDefinition) {
        Map parameters = macroDefinition.getParameters();
        String newParameters = StringUtils.join(parameters.values(), (char)',');
        return newParameters;
    }
}

