/*
 * Decompiled with CFR 0.152.
 */
package com.greenpepper.confluence.tools;

import com.greenpepper.util.URIUtil;
import com.greenpepper.util.cli.ArgumentMissingException;
import com.greenpepper.util.cli.CommandLine;
import com.greenpepper.util.cli.ParseException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcClientLite;
import org.apache.xmlrpc.XmlRpcException;

public class GetSpec {
    public static final String URI = "http://localhost:8090";
    public static final String RPC_PATH = "/rpc/xmlrpc";
    private static final Vector EMPTY = new Vector(0);
    private static final Object USER_NAME = "admin";
    private static final Object PASSWORD = "admin";
    private CommandLine cli = new CommandLine();

    public void run(String ... args) throws Exception {
        this.defineCommandLine();
        if (!this.parseCommandLine(args)) {
            return;
        }
        this.getSpecification();
    }

    private boolean parseCommandLine(String[] args) throws ParseException {
        this.cli.parse(args);
        if (this.optionSpecified("help")) {
            return this.displayUsage();
        }
        if (this.optionSpecified("version")) {
            return this.displayVersion();
        }
        if (this.confluenceUrl() == null) {
            throw new ArgumentMissingException("confluence_url");
        }
        return true;
    }

    private String confluenceUrl() {
        return this.cli.getArgument(0) != null ? URIUtil.decoded((String)this.cli.getArgument(0)) : URI;
    }

    private boolean optionSpecified(String name) {
        return this.cli.hasOptionValue(name);
    }

    private void getSpecification() {
        try {
            String xmlRpcUrl = this.getXmlRpcURL();
            System.out.println("GettingSpecification : " + xmlRpcUrl);
            XmlRpcClientLite rpcClient = new XmlRpcClientLite(xmlRpcUrl);
            Vector<Object> params = new Vector<Object>(3);
            params.add(USER_NAME);
            params.add(PASSWORD);
            Vector<Object> specs = new Vector<Object>(2);
            specs.add("GREENPEPPERDEMO");
            specs.add("Bank");
            specs.add(Boolean.FALSE);
            params.add(specs);
            String specification = (String)rpcClient.execute(GetSpec.buildRequest("getRenderedSpecification"), params);
            System.err.println(specification);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (XmlRpcException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getXmlRpcURL() {
        return this.confluenceUrl() + RPC_PATH;
    }

    private void defineCommandLine() {
        String banner = "com.greenpepper.confluence.tools.ListRepo [options] confluence_url\nList all the repositories found in the specified confluence ";
        this.cli.setBanner(banner);
        this.cli.defineOption(this.cli.buildOption("help", new String[]{"--help", "Display this help and exit"}));
        this.cli.defineOption(this.cli.buildOption("version", new String[]{"--version", "Output version information and exit"}));
    }

    private boolean displayVersion() {
        System.out.println(String.format("GreenPepper version \"%s\"", "4.2.3"));
        return false;
    }

    private boolean displayUsage() {
        System.out.println(this.cli.usage());
        return false;
    }

    private static String buildRequest(String methodName) {
        return "greenpepper1." + methodName;
    }

    public static void main(String[] args) {
        GetSpec listRepo = new GetSpec();
        try {
            listRepo.run(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

