package dev.siris.module;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

/**
 * A logger isolated from the parent logger.
 */
public class ModuleLogger extends Logger {

    private String prefix;

    protected ModuleLogger(Module module) {
        super(module.getOwner().getName(), null);

        // This creates the prefix: [CivCore][MyModule] ....
        prefix = "[" + module.getName() + "] ";

        // Set parent and level.
        setParent(module.getOwner().getLogger());
        setLevel(Level.ALL);
    }

    @Override
    public void log(LogRecord record) {
        // Apply prefix.
        record.setMessage(prefix + record.getMessage());
        super.log(record);
    }
}
