package com.webapp.mybatis.filter;

import java.sql.Connection;
import java.util.Properties;

import org.apache.ibatis.executor.statement.BaseStatementHandler;
import org.apache.ibatis.executor.statement.RoutingStatementHandler;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;

import com.webapp.utils.clz.ClzUtils;

@Intercepts({ @Signature(type = StatementHandler.class, method = "prepare", args = {Connection.class}) })
public class DaoAdapter implements Interceptor {

	public Object intercept(Invocation invocation) throws Throwable {
		RoutingStatementHandler handler = (RoutingStatementHandler) invocation.getTarget();

		BaseStatementHandler delegate = (BaseStatementHandler)ClzUtils.getFieldVal("delegate", handler);
		MappedStatement ms = (MappedStatement)ClzUtils.getFieldVal("mappedStatement", delegate);
		String clzName = ms.getId();
		Class<?> clz = Class.forName(clzName.substring(0, clzName.lastIndexOf(".")));

		BoundSql boundSql = delegate.getBoundSql();
		String sql = boundSql.getSql();
		if(sql.contains("${table}")){
			String table = ClzUtils.getFieldVal("table", clz).toString();
			sql = sql.replaceFirst("\\$\\{table\\}", table);
		}
		if(sql.contains("${column}")){
			String selCols = ClzUtils.getFieldVal("selCols", clz).toString();
			sql = sql.replaceFirst("\\$\\{column\\}", selCols);
		}

		ClzUtils.setFieldVal(boundSql, "sql", sql);
		return invocation.proceed();
	}

	@Override
	public Object plugin(Object target) {
		return (target instanceof StatementHandler) ? Plugin.wrap(target, this) : target;
	}

	@Override
	public void setProperties(Properties properties) {
	}
}