package com.webapp.mybatis.filter;

import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.ParameterMode;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts({
	@Signature(type = Executor.class, method = "update", args = { MappedStatement.class, Object.class }),
	@Signature(type = Executor.class, method = "query", args = { MappedStatement.class, Object.class,
				RowBounds.class, ResultHandler.class })
})
public class TimeInterceptor implements Interceptor {

	private static final Logger logger = LoggerFactory.getLogger(TimeInterceptor.class);

	@Override
	public Object intercept(Invocation invocation) throws Throwable {
		MappedStatement mapStat = (MappedStatement) invocation.getArgs()[0];
		Object paramObj = null;
		if (invocation.getArgs().length > 1) {
			paramObj = invocation.getArgs()[1];
		}
		String statementId = mapStat.getId();
		BoundSql boundSql = mapStat.getBoundSql(paramObj);
		Configuration cfg = mapStat.getConfiguration();
		String sql = showSql(cfg, boundSql);

		long start = System.currentTimeMillis();
		Object result = invocation.proceed();
		long end = System.currentTimeMillis();
		long time = (end - start);

		logger.debug(String.format("%1s --> %2sms\n\t%3s", statementId, time, sql));
		return result;
	}

	private static String showSql(Configuration cfg, BoundSql boundSql) {
		String sql = boundSql.getSql().replaceAll("[\\s]+", " ");
		List<ParameterMapping> paramMaps = boundSql.getParameterMappings();
		Object paramObj = boundSql.getParameterObject();

		TypeHandlerRegistry typeHandReg = cfg.getTypeHandlerRegistry();
		if (paramMaps != null) {
            for (int i = 0; i < paramMaps.size(); i++) {
                ParameterMapping parameterMapping = paramMaps.get(i);
                if (parameterMapping.getMode() != ParameterMode.OUT) {
                    Object value;
                    String propertyName = parameterMapping.getProperty();
                    if (boundSql.hasAdditionalParameter(propertyName)) {
                        value = boundSql.getAdditionalParameter(propertyName);
                    } else if (paramObj == null) {
                        value = null;
                    } else if (typeHandReg.hasTypeHandler(paramObj.getClass())) {
                        value = paramObj;
                    } else {
                        MetaObject metaObject = cfg.newMetaObject(paramObj);
                        value = metaObject.getValue(propertyName);
                    }
                    sql = sql.replaceFirst("\\?", getParamVal(value));
                }
            }
        }
		return sql;
	}

	private static String getParamVal(Object obj) {
		String value = null;
		if (obj instanceof String) {
			value = String.format("'%s'", obj.toString());
		} else if (obj instanceof Date) {
			DateFormat format = DateFormat.getDateTimeInstance(DateFormat.DEFAULT, DateFormat.DEFAULT, Locale.CHINA);
			value = String.format("'%s'", format.format(new Date()));
		} else {
			value = obj != null ? obj.toString() : "";
		}
		return value;
	}

	@Override
	public Object plugin(Object target) {
		if(target instanceof Executor) {
			return Plugin.wrap(target, this);
		}
		return target;
	}

	@Override
	public void setProperties(Properties properties) {
	}

}