package com.webapp.mybatis.helper;

import java.util.Map;

import org.apache.ibatis.jdbc.SQL;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.webapp.mybatis.helper.SqlHelper.AndOr;
import com.webapp.utils.string.Utils;

public class DaoHelper {

//	private static final Logger logger = LoggerFactory.getLogger(DaoHelper.class);

	private static final String pkey = "key";
	private static final String pval = "val";

	public static <T> String wrapPk4Upd(SQL base, String pkWhere, T model){
		String set = exp(model, ",");
		return base.SET(set).WHERE(pkWhere).toString();
	}
	public static <T> String wrapPk4Other(SQL base, String pkWhere){
		return base.WHERE(pkWhere).toString();
	}

	public static <T> String wrapInsert(SQL base, String columns, String vals){
		return base.VALUES(columns, vals).toString();
	}


	public static <T> String wrapInsert(SQL base, String columns, String vals, int count){
		StringBuffer result = new StringBuffer();
		result.append(String.format("%1$s (%2$s) values", base.toString(), columns));

		for(int i=0; i<count; i++){
			result.append(String.format(" (%1$s),", vals.replace("0", i + "")));
		}
		return Utils.delTail(result.toString());
	}


	public static String wrapKv(SQL base, Map<String, Object> param){
		String where = param.get(pkey) + String.format("=#{%s}", pval);
		return base.WHERE(where).toString();
	}

	public static String wrapWhere(SQL base, Where where){
		return String.format("%1$s %2$s", base.toString(), where.toSql());
	}

	public static <T> String wrapModel(SQL base, T param){
		String where = exp(param, " " + AndOr.AND.name());
		return base.WHERE(where).toString();
	}

	private static <T> String exp(T model, String spilt) {
		JSONObject json = JSON.parseObject(JSON.toJSONString(model));
		StringBuffer data = new StringBuffer();
		json.forEach((key,val)->data.append(String.format("%1$s=#{%2$s}%3$s", Utils.toSnake(key), key, spilt)).append(" "));

		return Utils.delTail(data.toString().trim(), spilt);
	}

}
