package com.webapp.mybatis.helper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;

import com.alibaba.fastjson.JSONObject;
import com.webapp.mybatis.helper.Where.Op;
import com.webapp.mybatis.helper.Where.Order;
import com.webapp.utils.string.Utils;

public class SqlHelper {

	protected enum Like{
		LEFT, RIGHT, ALL;
	}
	protected enum AndOr{
		AND, OR;
	}
	protected enum Keys{
		ORDER("ORDER BY"), LIMIT("LIMIT");

		private String keys;
		Keys(String keys){
			this.keys = keys;
		}
		public String toString() {
			return this.keys.toString();
		}
	}

	protected static String limits(int index, int count){
		return String.format("%1$s %2$s,%3$s", Keys.LIMIT, index, count);
	}

	protected static String orderBy(Order order, String ...name){
		String names = Utils.split(Arrays.asList(name));
		return String.format("%1$s %2$s %3$s", Keys.ORDER, names, order.name());
	}

	protected static String between(SortedMap<String, Object> params, String name, Object min, Object max){
		String preMin = SqlHelper.handle(params, min);
		String preMax = SqlHelper.handle(params, max);

		return String.format("%1$s %2$s %3$s AND %4$s", name, Op.BETWEEN, preMin, preMax);
	}

	protected static String in(SortedMap<String, Object> params, String name, boolean isNot, Object ...vals){
		String[] preVals = SqlHelper.handleArray(params, vals);

		return String.format("%1$s %2$s (%3$s)", name, isNot ? Op.NIN : Op.IN, StringUtils.join(preVals, ","));
	}

	protected static String like(SortedMap<String, Object> params, String name, boolean isNot, Like like, Object val){
		val = SqlHelper.handleLike(params, val, like);

		return String.format("%1$s %2$s %3$s", name, isNot ? Op.NLike : Op.LIKE, val);
	}

	protected static <T> String where(SortedMap<String, Object> params, JSONObject model) {
		SqlHelper.handleModel(params, model);

		List<String> data = new ArrayList<>();
		model.forEach((key,val)->data.add(String.format("%1$s=%2$s", Utils.toSnake(key), val)));

		return StringUtils.join(data, " AND ");
	}

	protected static String where(SortedMap<String, Object> params, String name, Op op, Object val){
		val = SqlHelper.handle(params, val);
		return String.format("%1$s%2$s%3$s", name, op, val);
	}

	protected static String where(String name, Op op){
		return String.format("%1$s %2$s", name, op);
	}

	protected static String all(SortedMap<String, Object> params, String name, Op op, Object ...vals){
		String where = "";
		if(op.equals(Op.BETWEEN)){
			if(vals.length != 2) {
				throw new RuntimeException("Parameter number is not correct");
			}
			where = SqlHelper.between(params, name, vals[0], vals[1]);
		}else if(op.equals(Op.ISNULL) || op.equals(Op.NISNULL)){
			where = SqlHelper.where(name, op);
		}else if(op.equals(Op.IN) || op.equals(Op.NIN)){
			where = SqlHelper.in(params, name, op.equals(Op.NIN) ? false : true, vals);
		}else if(op.equals(Op.LIKE) || op.equals(Op.NLike)){
			where = SqlHelper.like(params, name, op.equals(Op.NLike) ? false : true, Like.ALL, vals[0]);
		}else {
			if(vals.length != 1) {
				throw new RuntimeException("Parameter number is not correct");
			}
			where = SqlHelper.where(params, name, op, vals[0]);
		}
		return where;
	}


	private static String param = "param";
	private static String[] handleArray(SortedMap<String, Object> params, Object ...vals) {
		String[] result = new String[vals.length];
		int count = params.size();
		for(int i=0; i<vals.length; i++){
			int index = (i + count);
			params.put(param + index, vals[i]);
			result[i] = prepare(index);
		}
		return result;
	}

	private static String handle(SortedMap<String, Object> params, Object val) {
		int index = params.size();
		params.put(param + index, val);
		return prepare(index);
	}

	private static JSONObject handleModel(SortedMap<String, Object> params, JSONObject json) {
		int count = params.size();

		AtomicInteger index = new AtomicInteger(count);
		json.forEach((key, val)->{
			params.put(param + index.get(), val);
			json.put(key, prepare(index.getAndIncrement()));
		});
		return json;
	}

	private static String handleLike(SortedMap<String, Object> params, Object val, Like like) {
		int index = params.size();
		params.put(param + index, val);

		if(like.equals(Like.LEFT)) params.put(param + index, String.format("%1$s%2$s", val, "%"));
		if(like.equals(Like.RIGHT)) params.put(param + index, String.format("%1$s%2$s", "%", val));
		if(like.equals(Like.ALL)) params.put(param + index, String.format("%1$s%2$s%3$s", "%", val, "%"));

		return prepare(index);
	}
	private static String prepare(int index){
		return String.format("#{%1$s.param%2$s}", Where.PARAM_NAME, index);
	}
}
