package com.webapp.mybatis.helper;

import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.webapp.mybatis.helper.SqlHelper.AndOr;
import com.webapp.mybatis.helper.SqlHelper.Like;


/**
 * where
 */
public final class Where {

	protected static final String PARAM_NAME = "tp";
	private SortedMap<String, Object> tp = new TreeMap<>();
	public SortedMap<String, Object> getParams() {
		return tp;
	}
	private StringBuffer where = new StringBuffer();
	private StringBuffer orderLimit = new StringBuffer();
	private static DateFormat df = DateFormat.getDateTimeInstance();
	private Where() {}
	private Where(String where) {
		this.where.append(where);
	}

	public static Where of() {
		return new Where();
	}
	public static Where of(String name, Op op, Object ...vals) {
		Where w = of();
		return w.addAnd(SqlHelper.all(w.tp, name, op, vals));
	}
	public static <T> Where of(T model) {
		Where w = of();
		JSONObject json = JSON.parseObject(JSON.toJSONString(model));
		return w.addAnd(SqlHelper.where(w.tp, json));
	}

	public enum Order {
		DESC, ASC;
	}

	public enum Op{
		EQ("="), NEQ("!="), GT(">"), GTE(">="), LT("<"), LTE("<="),
		LIKE("LIKE"), NLike("NOT LIKE"),
		IN("IN"), NIN("NOT IN"), ISNULL("IS NULL"),
		NISNULL("NOT IS NULL"), BETWEEN("BETWEEN");

		private String op;
		Op(String op){
			this.op = op;
		}
		public String toString() {
			return this.op.toString();
		}
		public static Op of(String op){
			List<Op> ops = Arrays.asList(values());
			for(Op ofOp : ops){
				if(ofOp.op.equals(op.toUpperCase())) return ofOp;
			}
			return null;
		}
	}

	private Where addAnd(String cnd){
		if(StringUtils.isNotEmpty(cnd))
			where.append(String.format(" %1$s %2$s", AndOr.AND.name(), cnd));
		return this;
	}
	private Where addOr(String cnd){
		if(StringUtils.isNotEmpty(cnd))
			where.append(String.format(" %1$s %2$s", AndOr.OR.name(), cnd));
		return this;
	}

	public Where and(String name, Op op, Object ...vals){
		return addAnd(SqlHelper.all(tp, name, op, vals));
	}
	public Where andBetween(String name, Object min, Object max){
		return addAnd(SqlHelper.between(tp, name, min, max));
	}
	public Where andEq(String name, Object val){
		return addAnd(SqlHelper.where(tp, name, Op.EQ, val));
	}
	public Where andNotEq(String name, Object val){
		return addAnd(SqlHelper.where(tp, name, Op.NEQ, val));
	}
	public Where andGT(String name, Object val){
		return addAnd(SqlHelper.where(tp, name, Op.GT, val));
	}
	public Where andGTE(String name, Object val){
		return addAnd(SqlHelper.where(tp, name, Op.GTE, val));
	}
	public Where andLT(String name, Object val){
		return addAnd(SqlHelper.where(tp, name, Op.LT, val));
	}
	public Where andLTE(String name, Object val){
		return addAnd(SqlHelper.where(tp, name, Op.LTE, val));
	}

	public Where andIn(String name, Object ...vals){
		return addAnd(SqlHelper.in(tp, name, false, vals));
	}
	public Where andNotIn(String name, Object ...vals){
		return addAnd(SqlHelper.in(tp, name, true, vals));
	}
	public Where andIsNull(String name){
		return addAnd(SqlHelper.where(name, Op.ISNULL));
	}
	public Where andIsNotNull(String name){
		return addAnd(SqlHelper.where(name, Op.NISNULL));
	}

	public Where andLike(String name, String val){
		return addAnd(SqlHelper.like(tp, name, false, Like.ALL, val));
	}
	public Where andNotLike(String name, String val){
		return addAnd(SqlHelper.like(tp, name, true, Like.ALL, val));
	}
	public Where andLikeL(String name, String val){
		return addAnd(SqlHelper.like(tp, name, false, Like.LEFT, val));
	}
	public Where andNotLikeL(String name, String val){
		return addAnd(SqlHelper.like(tp, name, true, Like.LEFT, val));
	}
	public Where andLikeR(String name, String val){
		return addAnd(SqlHelper.like(tp, name, false, Like.RIGHT, val));
	}
	public Where andNotLikeR(String name, String val){
		return addAnd(SqlHelper.like(tp, name, true, Like.RIGHT, val));
	}


	public Where or(String name, Op op, Object ...vals){
		return addOr(SqlHelper.all(tp, name, op, vals));
	}
	public Where orBetween(String name, Object min, Object max){
		return addOr(SqlHelper.between(tp, name, min, max));
	}
	public Where orEq(String name, Object val){
		return addOr(SqlHelper.where(tp, name, Op.EQ, val));
	}
	public Where orNotEq(String name, Object val){
		return addOr(SqlHelper.where(tp, name, Op.NEQ, val));
	}
	public Where orGT(String name, Object val){
		return addOr(SqlHelper.where(tp, name, Op.GT, val));
	}
	public Where orGTE(String name, Object val){
		return addOr(SqlHelper.where(tp, name, Op.GTE, val));
	}
	public Where orLT(String name, Object val){
		return addOr(SqlHelper.where(tp, name, Op.LT, val));
	}
	public Where orLTE(String name, Object val){
		return addOr(SqlHelper.where(tp, name, Op.LTE, val));
	}

	public Where orIn(String name, Object ...vals){
		return addOr(SqlHelper.in(tp, name, false, vals));
	}
	public Where orNotIn(String name, Object ...vals){
		return addOr(SqlHelper.in(tp, name, true, vals));
	}
	public Where orIsNull(String name){
		return addOr(SqlHelper.where(name, Op.ISNULL));
	}
	public Where orIsNotNull(String name){
		return addOr(SqlHelper.where(name, Op.NISNULL));
	}

	public Where orLike(String name, String val){
		return addOr(SqlHelper.like(tp, name, false, Like.ALL, val));
	}
	public Where orNotLike(String name, String val){
		return addOr(SqlHelper.like(tp, name, true, Like.ALL, val));
	}
	public Where orLikeL(String name, String val){
		return addOr(SqlHelper.like(tp, name, false, Like.LEFT, val));
	}
	public Where orNotLikeL(String name, String val){
		return addOr(SqlHelper.like(tp, name, true, Like.LEFT, val));
	}
	public Where orLikeR(String name, String val){
		return addOr(SqlHelper.like(tp, name, false, Like.RIGHT, val));
	}
	public Where orNotLikeR(String name, String val){
		return addOr(SqlHelper.like(tp, name, true, Like.RIGHT, val));
	}


	/* sql wrap */
	private Where addWhere(Where wrap){
		String wrapWhere = wrap.where.toString();
		SortedMap<String, Object> wrapParam = wrap.tp;

		int count = tp.size();
		AtomicInteger index = new AtomicInteger();
		Iterator<String> keys = wrapParam.keySet().iterator();
		for(;keys.hasNext();){
			String key = keys.next();
			String tar = index.toString();
			String replace = String.valueOf(index.getAndIncrement() + count);

			tp.put(key.replace(tar, replace), wrapParam.get(key));
			wrapWhere = wrapWhere.replace(tar, replace);
		}
		wrap.where = new StringBuffer(wrapWhere);
		return wrap;
	}
	private Where addWrap(AndOr andOr, Where wrap){
		String wrapSql = addWhere(wrap).toWrapSql();
		if(StringUtils.isNotEmpty(wrapSql))
			where.append(String.format(" %1$s (%2$s)", andOr.name(), wrapSql));
		return this;
	}
	public Where andWrap(Where wrap){
		return addWrap(AndOr.AND, wrap);
	}
	public Where orWrap(Where wrap){
		return addWrap(AndOr.OR, wrap);
	}

	/* sql order and limit */
	private Where addOrderLimit(String cnd){
		orderLimit.append(" " + cnd);
		return this;
	}
	public Where order(String ...name){
		return addOrderLimit(SqlHelper.orderBy(Order.ASC, name));
	}
	public Where order(Order order, String ...name){
		return addOrderLimit(SqlHelper.orderBy(order, name));
	}
	public Where limit(int count){
		return addOrderLimit(SqlHelper.limits(0, count));
	}
	public Where limit(int index, int count){
		return addOrderLimit(SqlHelper.limits(index, count));
	}

	/* sql convert */
	private String toBaseSql() {
		String sql = where.toString().trim();
		if(StringUtils.isNotEmpty(sql)){
			if(sql.startsWith(AndOr.AND.toString())){
				sql = sql.replaceFirst(AndOr.AND.toString(), "").trim();
			}else if(sql.startsWith(AndOr.OR.toString())){
				sql = sql.replaceFirst(AndOr.OR.toString(), "").trim();
			}
			return String.format("WHERE %1$s %2$s", sql, orderLimit.toString().trim());
		}
		return orderLimit.toString().trim();
	}
	private String toWrapSql(){
		String sql = toBaseSql();
		if(sql.startsWith("WHERE")){
			sql = sql.replaceFirst("WHERE", "");
		}
		return sql;
	}
	public String toSql() {
		return toBaseSql();
	}

	public String toPlainSql() {
		String sql = toBaseSql();
		Set<String> keys = tp.keySet();
		for (String key : keys) {
			String val = fmt(tp.get(key));
			sql = sql.replace(String.format("#{%1$s.%2$s}", PARAM_NAME, key), val);
		}
		return sql;
	}
	private static String fmt(Object val){
		String kv = "";
		if(val instanceof Date){
			kv += String.format("'%s'", df.format(val));
		}else if(val instanceof String){
			kv += String.format("'%s'", val);
		}else {
			kv += String.format("%s", val);
		}
		return kv;
	}
	public String toString(){
		return toSql();
	}
}
