/*
 * Decompiled with CFR 0.152.
 */
package com.github.surpassm.common.base;

import com.github.surpassm.common.jackson.AbstractBaseDomain;
import com.github.surpassm.common.jackson.AbstractBaseResult;
import com.github.surpassm.common.jackson.BaseResultFactory;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ModelAttribute;

public abstract class AbstractBaseController<T extends AbstractBaseDomain> {
    private static final String ENVIRONMENT_LOGGING_LEVEL_MY_SHOP = "logging.level.com.liaoin";
    @Resource
    protected HttpServletRequest request;
    @Resource
    private HttpServletResponse response;
    @Resource
    private ConfigurableApplicationContext applicationContext;

    @ModelAttribute
    public void initReqAndRes(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    protected AbstractBaseResult success(String self, T attribute) {
        return BaseResultFactory.getInstance(this.response).build(self, attribute);
    }

    protected AbstractBaseResult success(String self, int next, int last, List<T> attributes) {
        return BaseResultFactory.getInstance(this.response).build(self, next, last, attributes);
    }

    protected AbstractBaseResult error(String title, String detail) {
        return this.error(HttpStatus.UNAUTHORIZED.value(), title, detail);
    }

    protected AbstractBaseResult error(int code, String title, String detail) {
        return BaseResultFactory.getInstance(this.response).build(code, title, detail, this.applicationContext.getEnvironment().getProperty(ENVIRONMENT_LOGGING_LEVEL_MY_SHOP));
    }
}

