/*
 * Decompiled with CFR 0.152.
 */
package com.github.surpassm.common.jackson;

import com.github.surpassm.common.jackson.AbstractBaseDomain;
import com.github.surpassm.common.jackson.AbstractBaseResult;
import com.github.surpassm.common.jackson.ErrorResult;
import com.github.surpassm.common.jackson.SuccessResult;
import java.util.List;
import javax.servlet.http.HttpServletResponse;

public class BaseResultFactory<T extends AbstractBaseDomain> {
    private static final String LOGGER_LEVEL_DEBUG = "DEBUG";
    private static BaseResultFactory baseResultFactory;
    private static HttpServletResponse response;

    private BaseResultFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static BaseResultFactory getInstance(HttpServletResponse response) {
        if (baseResultFactory == null) {
            Class<BaseResultFactory> clazz = BaseResultFactory.class;
            // MONITORENTER : com.github.surpassm.common.jackson.BaseResultFactory.class
            if (baseResultFactory == null) {
                baseResultFactory = new BaseResultFactory();
            }
            // MONITOREXIT : clazz
        }
        BaseResultFactory.response = response;
        baseResultFactory.initResponse();
        return baseResultFactory;
    }

    public AbstractBaseResult build(String self, T attributes) {
        return new SuccessResult<T>(self, attributes);
    }

    public AbstractBaseResult build(String self, int next, int last, List<T> attributes) {
        return new SuccessResult<T>(self, next, last, attributes);
    }

    public AbstractBaseResult build(Integer code, String title, String detail, String level) {
        response.setStatus(code.intValue());
        if (LOGGER_LEVEL_DEBUG.equals(level)) {
            return new ErrorResult(code, title, detail);
        }
        return new ErrorResult(code, title, null);
    }

    private void initResponse() {
        response.setHeader("Content-Type", "application/vnd.api+json");
    }
}

