/*
 * Decompiled with CFR 0.152.
 */
package com.github.surpassm.common.pojo;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.io.Serializable;
import java.time.LocalDateTime;

public class ValidateCode
implements Serializable {
    private String code;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private LocalDateTime expireTime;
    private Integer sendLimit = 0;

    public ValidateCode() {
    }

    public ValidateCode(String code, int expireIn) {
        this.code = code;
        this.expireTime = LocalDateTime.now().plusSeconds(expireIn);
    }

    public ValidateCode(String code, LocalDateTime expireTime) {
        this.code = code;
        this.expireTime = expireTime;
    }

    public boolean isExpried() {
        return LocalDateTime.now().isAfter(this.expireTime);
    }

    public String getCode() {
        return this.code;
    }

    public LocalDateTime getExpireTime() {
        return this.expireTime;
    }

    public Integer getSendLimit() {
        return this.sendLimit;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setExpireTime(LocalDateTime expireTime) {
        this.expireTime = expireTime;
    }

    public void setSendLimit(Integer sendLimit) {
        this.sendLimit = sendLimit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidateCode)) {
            return false;
        }
        ValidateCode other = (ValidateCode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        LocalDateTime this$expireTime = this.getExpireTime();
        LocalDateTime other$expireTime = other.getExpireTime();
        if (this$expireTime == null ? other$expireTime != null : !((Object)this$expireTime).equals(other$expireTime)) {
            return false;
        }
        Integer this$sendLimit = this.getSendLimit();
        Integer other$sendLimit = other.getSendLimit();
        return !(this$sendLimit == null ? other$sendLimit != null : !((Object)this$sendLimit).equals(other$sendLimit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValidateCode;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        LocalDateTime $expireTime = this.getExpireTime();
        result = result * 59 + ($expireTime == null ? 43 : ((Object)$expireTime).hashCode());
        Integer $sendLimit = this.getSendLimit();
        result = result * 59 + ($sendLimit == null ? 43 : ((Object)$sendLimit).hashCode());
        return result;
    }

    public String toString() {
        return "ValidateCode(code=" + this.getCode() + ", expireTime=" + this.getExpireTime() + ", sendLimit=" + this.getSendLimit() + ")";
    }
}

