/*
 * Decompiled with CFR 0.152.
 */
package com.github.surpassm.common.tool.algorithm;

public class RBTree<T extends Comparable<T>> {
    private RBTNode<T> mRoot = null;
    private static final boolean RED = false;
    private static final boolean BLACK = true;
    private static final int[] A = new int[]{10, 40, 30, 60, 90, 70, 20, 50, 80};
    private static final boolean M_DEBUG_INSERT = false;
    private static final boolean M_DEBUG_DELETE = false;

    private RBTNode<T> parentOf(RBTNode<T> node) {
        return node != null ? node.parent : null;
    }

    private boolean colorOf(RBTNode<T> node) {
        return node != null ? node.color : true;
    }

    private boolean isRed(RBTNode<T> node) {
        return node != null && !node.color;
    }

    private boolean isBlack(RBTNode<T> node) {
        return !this.isRed(node);
    }

    private void setBlack(RBTNode<T> node) {
        if (node != null) {
            node.color = true;
        }
    }

    private void setRed(RBTNode<T> node) {
        if (node != null) {
            node.color = false;
        }
    }

    private void setParent(RBTNode<T> node, RBTNode<T> parent) {
        if (node != null) {
            node.parent = parent;
        }
    }

    private void setColor(RBTNode<T> node, boolean color) {
        if (node != null) {
            node.color = color;
        }
    }

    private void preOrder(RBTNode<T> tree) {
        if (tree != null) {
            System.out.print(tree.key + " ");
            this.preOrder(tree.left);
            this.preOrder(tree.right);
        }
    }

    public void preOrder() {
        this.preOrder(this.mRoot);
    }

    private void inOrder(RBTNode<T> tree) {
        if (tree != null) {
            this.inOrder(tree.left);
            System.out.print(tree.key + " ");
            this.inOrder(tree.right);
        }
    }

    public void inOrder() {
        this.inOrder(this.mRoot);
    }

    private void postOrder(RBTNode<T> tree) {
        if (tree != null) {
            this.postOrder(tree.left);
            this.postOrder(tree.right);
            System.out.print(tree.key + " ");
        }
    }

    public void postOrder() {
        this.postOrder(this.mRoot);
    }

    private RBTNode<T> search(RBTNode<T> x, T key) {
        if (x == null) {
            return x;
        }
        int cmp = key.compareTo(x.key);
        if (cmp < 0) {
            return this.search(x.left, key);
        }
        if (cmp > 0) {
            return this.search(x.right, key);
        }
        return x;
    }

    public RBTNode<T> search(T key) {
        return this.search(this.mRoot, key);
    }

    private RBTNode<T> iterativeSearch(RBTNode<T> x, T key) {
        while (x != null) {
            int cmp = key.compareTo(x.key);
            if (cmp < 0) {
                x = x.left;
                continue;
            }
            if (cmp > 0) {
                x = x.right;
                continue;
            }
            return x;
        }
        return x;
    }

    public RBTNode<T> iterativeSearch(T key) {
        return this.iterativeSearch(this.mRoot, key);
    }

    private RBTNode<T> minimum(RBTNode<T> tree) {
        if (tree == null) {
            return null;
        }
        while (tree.left != null) {
            tree = tree.left;
        }
        return tree;
    }

    public T minimum() {
        RBTNode<T> p = this.minimum(this.mRoot);
        if (p != null) {
            return p.key;
        }
        return null;
    }

    private RBTNode<T> maximum(RBTNode<T> tree) {
        if (tree == null) {
            return null;
        }
        while (tree.right != null) {
            tree = tree.right;
        }
        return tree;
    }

    public T maximum() {
        RBTNode<T> p = this.maximum(this.mRoot);
        if (p != null) {
            return p.key;
        }
        return null;
    }

    public RBTNode<T> successor(RBTNode<T> x) {
        if (x.right != null) {
            return this.minimum(x.right);
        }
        RBTNode y = x.parent;
        while (y != null && x == y.right) {
            x = y;
            y = y.parent;
        }
        return y;
    }

    public RBTNode<T> predecessor(RBTNode<T> x) {
        if (x.left != null) {
            return this.maximum(x.left);
        }
        RBTNode y = x.parent;
        while (y != null && x == y.left) {
            x = y;
            y = y.parent;
        }
        return y;
    }

    private void leftRotate(RBTNode<T> x) {
        RBTNode y = x.right;
        x.right = y.left;
        if (y.left != null) {
            y.left.parent = x;
        }
        y.parent = x.parent;
        if (x.parent == null) {
            this.mRoot = y;
        } else if (x.parent.left == x) {
            x.parent.left = y;
        } else {
            x.parent.right = y;
        }
        y.left = x;
        x.parent = y;
    }

    private void rightRotate(RBTNode<T> y) {
        RBTNode x = y.left;
        y.left = x.right;
        if (x.right != null) {
            x.right.parent = y;
        }
        x.parent = y.parent;
        if (y.parent == null) {
            this.mRoot = x;
        } else if (y == y.parent.right) {
            y.parent.right = x;
        } else {
            y.parent.left = x;
        }
        x.right = y;
        y.parent = x;
    }

    private void insertFixUp(RBTNode<T> node) {
        RBTNode<T> parent;
        while ((parent = this.parentOf(node)) != null && this.isRed(parent)) {
            RBTNode<T> tmp;
            RBTNode uncle;
            RBTNode<T> gparent = this.parentOf(parent);
            if (parent == gparent.left) {
                uncle = gparent.right;
                if (uncle != null && this.isRed(uncle)) {
                    this.setBlack(uncle);
                    this.setBlack(parent);
                    this.setRed(gparent);
                    node = gparent;
                    continue;
                }
                if (parent.right == node) {
                    this.leftRotate(parent);
                    tmp = parent;
                    parent = node;
                    node = tmp;
                }
                this.setBlack(parent);
                this.setRed(gparent);
                this.rightRotate(gparent);
                continue;
            }
            uncle = gparent.left;
            if (uncle != null && this.isRed(uncle)) {
                this.setBlack(uncle);
                this.setBlack(parent);
                this.setRed(gparent);
                node = gparent;
                continue;
            }
            if (parent.left == node) {
                this.rightRotate(parent);
                tmp = parent;
                parent = node;
                node = tmp;
            }
            this.setBlack(parent);
            this.setRed(gparent);
            this.leftRotate(gparent);
        }
        this.setBlack(this.mRoot);
    }

    private void insert(RBTNode<T> node) {
        int cmp;
        RBTNode<T> y = null;
        RBTNode<T> x = this.mRoot;
        while (x != null) {
            y = x;
            cmp = node.key.compareTo(x.key);
            if (cmp < 0) {
                x = x.left;
                continue;
            }
            x = x.right;
        }
        node.parent = y;
        if (y != null) {
            cmp = node.key.compareTo(y.key);
            if (cmp < 0) {
                y.left = node;
            } else {
                y.right = node;
            }
        } else {
            this.mRoot = node;
        }
        node.color = false;
        this.insertFixUp(node);
    }

    public void insert(T key) {
        RBTNode node = new RBTNode(this, key, true, null, null, null);
        if (node != null) {
            this.insert((T)node);
        }
    }

    private void removeFixUp(RBTNode<T> node, RBTNode<T> parent) {
        while ((node == null || this.isBlack(node)) && node != this.mRoot) {
            RBTNode other;
            if (parent.left == node) {
                other = parent.right;
                if (this.isRed(other)) {
                    this.setBlack(other);
                    this.setRed(parent);
                    this.leftRotate(parent);
                    other = parent.right;
                }
                if ((other.left == null || this.isBlack(other.left)) && (other.right == null || this.isBlack(other.right))) {
                    this.setRed(other);
                    node = parent;
                    parent = this.parentOf(node);
                    continue;
                }
                if (other.right == null || this.isBlack(other.right)) {
                    this.setBlack(other.left);
                    this.setRed(other);
                    this.rightRotate(other);
                    other = parent.right;
                }
                this.setColor(other, this.colorOf(parent));
                this.setBlack(parent);
                this.setBlack(other.right);
                this.leftRotate(parent);
                node = this.mRoot;
                break;
            }
            other = parent.left;
            if (this.isRed(other)) {
                this.setBlack(other);
                this.setRed(parent);
                this.rightRotate(parent);
                other = parent.left;
            }
            if ((other.left == null || this.isBlack(other.left)) && (other.right == null || this.isBlack(other.right))) {
                this.setRed(other);
                node = parent;
                parent = this.parentOf(node);
                continue;
            }
            if (other.left == null || this.isBlack(other.left)) {
                this.setBlack(other.right);
                this.setRed(other);
                this.leftRotate(other);
                other = parent.left;
            }
            this.setColor(other, this.colorOf(parent));
            this.setBlack(parent);
            this.setBlack(other.left);
            this.rightRotate(parent);
            node = this.mRoot;
            break;
        }
        if (node != null) {
            this.setBlack(node);
        }
    }

    private void remove(RBTNode<T> node) {
        if (node.left != null && node.right != null) {
            RBTNode<T> replace = node;
            replace = replace.right;
            while (replace.left != null) {
                replace = replace.left;
            }
            if (this.parentOf(node) != null) {
                if (this.parentOf(node).left == node) {
                    this.parentOf(node).left = replace;
                } else {
                    this.parentOf(node).right = replace;
                }
            } else {
                this.mRoot = replace;
            }
            RBTNode child = replace.right;
            RBTNode<T> parent = this.parentOf(replace);
            boolean color = this.colorOf(replace);
            if (parent == node) {
                parent = replace;
            } else {
                if (child != null) {
                    this.setParent(child, parent);
                }
                parent.left = child;
                replace.right = node.right;
                this.setParent(node.right, replace);
            }
            replace.parent = node.parent;
            replace.color = node.color;
            replace.left = node.left;
            node.left.parent = replace;
            if (color) {
                this.removeFixUp(child, parent);
            }
            node = null;
            return;
        }
        RBTNode child = node.left != null ? node.left : node.right;
        RBTNode parent = node.parent;
        boolean color = node.color;
        if (child != null) {
            child.parent = parent;
        }
        if (parent != null) {
            if (parent.left == node) {
                parent.left = child;
            } else {
                parent.right = child;
            }
        } else {
            this.mRoot = child;
        }
        if (color) {
            this.removeFixUp(child, parent);
        }
        node = null;
    }

    public void remove(T key) {
        RBTNode<T> node = this.search(this.mRoot, key);
        if (node != null) {
            this.remove((T)node);
        }
    }

    private void destroy(RBTNode<T> tree) {
        if (tree == null) {
            return;
        }
        if (tree.left != null) {
            this.destroy(tree.left);
        }
        if (tree.right != null) {
            this.destroy(tree.right);
        }
        tree = null;
    }

    public void clear() {
        this.destroy(this.mRoot);
        this.mRoot = null;
    }

    private void print(RBTNode<T> tree, T key, int direction) {
        if (tree != null) {
            if (direction == 0) {
                System.out.printf("%2d(B) is root\n", tree.key);
            } else {
                System.out.printf("%2d(%s) is %2d's %6s child\n", tree.key, this.isRed(tree) ? "R" : "B", key, direction == 1 ? "right" : "left");
            }
            this.print(tree.left, tree.key, -1);
            this.print(tree.right, tree.key, 1);
        }
    }

    public void print() {
        if (this.mRoot != null) {
            this.print(this.mRoot, this.mRoot.key, 0);
        }
    }

    public static void main(String[] args) {
        int i;
        int ilen = A.length;
        RBTree<Integer> tree = new RBTree<Integer>();
        System.out.printf("== \u539f\u59cb\u6570\u636e: ", new Object[0]);
        for (i = 0; i < ilen; ++i) {
            System.out.printf("%d ", A[i]);
        }
        System.out.printf("\n", new Object[0]);
        for (i = 0; i < ilen; ++i) {
            tree.insert(A[i]);
        }
        System.out.printf("== \u524d\u5e8f\u904d\u5386: ", new Object[0]);
        tree.preOrder();
        System.out.printf("\n== \u4e2d\u5e8f\u904d\u5386: ", new Object[0]);
        tree.inOrder();
        System.out.printf("\n== \u540e\u5e8f\u904d\u5386: ", new Object[0]);
        tree.postOrder();
        System.out.printf("\n", new Object[0]);
        System.out.printf("== \u6700\u5c0f\u503c: %s\n", tree.minimum());
        System.out.printf("== \u6700\u5927\u503c: %s\n", tree.maximum());
        System.out.printf("== \u6811\u7684\u8be6\u7ec6\u4fe1\u606f: \n", new Object[0]);
        tree.print();
        System.out.printf("\n", new Object[0]);
        tree.clear();
    }

    public static class RBTNode<T extends Comparable<T>> {
        boolean color;
        T key;
        RBTNode<T> left;
        RBTNode<T> right;
        RBTNode<T> parent;
        final /* synthetic */ RBTree this$0;

        public RBTNode(T key, boolean color, RBTNode<T> parent, RBTNode<T> left, RBTNode<T> right) {
            this.this$0 = this$0;
            this.key = key;
            this.color = color;
            this.parent = parent;
            this.left = left;
            this.right = right;
        }

        public T getKey() {
            return this.key;
        }

        public String toString() {
            return "" + this.key + (!this.color ? "(R)" : "B");
        }
    }
}

