/*
 * Decompiled with CFR 0.152.
 */
package com.github.surpassm.common.tool.okhttp;

import com.github.surpassm.common.tool.okhttp.TrustAllCerts;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class OkhttpUtils {
    private static OkHttpClient client = new OkHttpClient.Builder().sslSocketFactory(OkhttpUtils.createSSLSocketFactory(), (X509TrustManager)new TrustAllCerts()).hostnameVerifier((hostname, session) -> true).build();
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");

    private static SSLSocketFactory createSSLSocketFactory() {
        SSLSocketFactory ssfFactory = null;
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, new TrustManager[]{new TrustAllCerts()}, new SecureRandom());
            ssfFactory = sc.getSocketFactory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ssfFactory;
    }

    public static Response get(String url) throws IOException {
        Request request = new Request.Builder().url(url).build();
        return client.newCall(request).execute();
    }

    public static Response delete(String url) throws IOException {
        Request request = new Request.Builder().url(url).delete().build();
        return client.newCall(request).execute();
    }

    public static Response post(String url, Map<String, String> params) throws IOException {
        FormBody.Builder b = new FormBody.Builder();
        params.forEach((k, v) -> {
            if (v != null) {
                b.add(k, v);
            }
        });
        FormBody body = b.build();
        Request request = new Request.Builder().url(url).post((RequestBody)body).build();
        return client.newCall(request).execute();
    }

    public static Response postJson(String url, String json) throws IOException {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
        Request request = new Request.Builder().header("Content-Type", "application/json;charset=UTF-8").url(url).post(body).build();
        return client.newCall(request).execute();
    }

    public static Response patch(String url, Map<String, String> params) throws IOException {
        FormBody.Builder b = new FormBody.Builder();
        params.forEach((k, v) -> b.add(k, v));
        FormBody body = b.build();
        Request request = new Request.Builder().url(url).patch((RequestBody)body).build();
        return client.newCall(request).execute();
    }

    public static Response postList(String url, List<Map<String, String>> paramsList) throws IOException {
        FormBody.Builder b = new FormBody.Builder();
        paramsList.forEach(i -> i.forEach((k, v) -> b.add(k, v)));
        FormBody body = b.build();
        Request request = new Request.Builder().url(url).post((RequestBody)body).build();
        return client.newCall(request).execute();
    }

    public static Response getIp(String ip) throws IOException {
        String url = "http://ip.taobao.com/service/getIpInfo.php?ip=%s";
        Request request = new Request.Builder().url(String.format(url, ip)).build();
        return client.newCall(request).execute();
    }
}

