/*
 * Decompiled with CFR 0.152.
 */
package com.github.surpassm.common.tool.util;

import com.github.surpassm.common.pojo.SurpassmFile;
import com.github.surpassm.common.tool.util.DateUtil;
import com.github.surpassm.common.tool.util.SystemClock;
import java.io.File;
import java.time.LocalDateTime;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class FileUtils {
    static String FILE_UPLOAD_PATH = "/upload/";

    public static SurpassmFile upload(MultipartFile file, HttpServletRequest request, String path) throws Exception {
        String fileName = SystemClock.millisClock().now() + "." + FileUtils.getFileType(file);
        int size = (int)file.getSize();
        String filePath = "/" + path + "/" + FileUtils.nowDate() + "/";
        File dest = new File(FileUtils.rootPath() + filePath + "/" + fileName);
        if (!dest.getParentFile().exists()) {
            dest.getParentFile().mkdirs();
        }
        try {
            file.transferTo(dest);
            SurpassmFile file1 = new SurpassmFile();
            file1.setFileOldName(FileUtils.getFileName(file));
            file1.setFileNewName(fileName);
            file1.setFileSuffix("." + FileUtils.getFileType(file));
            file1.setUrl(filePath + fileName);
            return file1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getFileType(MultipartFile file) {
        String[] s = file.getOriginalFilename().split("\\.");
        ArrayList<String> list = new ArrayList<String>();
        for (String s1 : s) {
            list.add(s1);
        }
        if (list.size() > 1) {
            return list.get(list.size() - 1).toString();
        }
        return null;
    }

    public static String nowDate() {
        return DateUtil.getDateTimeAsString(LocalDateTime.now(), "yyyy-MM-dd");
    }

    public static String rootPath() throws Exception {
        File directory = new File("");
        return directory.getCanonicalPath();
    }

    public static String http(HttpServletRequest request) {
        return request.getScheme() + "://" + request.getServerName() + ":" + request.getServerPort();
    }

    public static String getFileName(MultipartFile file) {
        String filename = file.getOriginalFilename().replace("." + FileUtils.getFileType(file), "");
        return filename;
    }

    public static boolean delFile(String filePath) throws Exception {
        String rootPath;
        String absolutePath;
        File file;
        if (StringUtils.isEmpty((Object)filePath)) {
            return false;
        }
        if (filePath.contains(FILE_UPLOAD_PATH)) {
            filePath = filePath.substring(filePath.indexOf(FILE_UPLOAD_PATH)).replace("/", "\\");
        }
        if (!(file = new File(absolutePath = (rootPath = FileUtils.rootPath()) + filePath)).exists()) {
            return false;
        }
        if (file.isFile()) {
            file.delete();
            return true;
        }
        return false;
    }
}

