/*
 * Decompiled with CFR 0.152.
 */
package com.github.surpassm.common.tool.util;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import javax.imageio.ImageIO;

public class GraphicHelper {
    public static String create(int width, int height, String imgType, OutputStream output) {
        int i;
        StringBuffer sb = new StringBuffer();
        Random random = new Random();
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics graphic = image.getGraphics();
        graphic.setColor(Color.getColor("F8F8F8"));
        graphic.fillRect(0, 0, width, height);
        Color[] colors = new Color[]{Color.BLUE, Color.GRAY, Color.GREEN, Color.RED, Color.BLACK, Color.ORANGE, Color.CYAN};
        for (i = 0; i < 50; ++i) {
            graphic.setColor(colors[random.nextInt(colors.length)]);
            int x = random.nextInt(width);
            int y = random.nextInt(height);
            int w = random.nextInt(20);
            int h = random.nextInt(20);
            int signA = random.nextBoolean() ? 1 : -1;
            int signB = random.nextBoolean() ? 1 : -1;
            graphic.drawLine(x, y, x + w * signA, y + h * signB);
        }
        graphic.setFont(new Font("Comic Sans MS", 1, 30));
        for (i = 0; i < 6; ++i) {
            int temp = random.nextInt(26) + 97;
            String s = String.valueOf((char)temp);
            sb.append(s);
            graphic.setColor(colors[random.nextInt(colors.length)]);
            graphic.drawString(s, i * (width / 6), height - height / 3);
        }
        graphic.dispose();
        try {
            ImageIO.write((RenderedImage)image, imgType, output);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    public static void drawBackground(Graphics g) {
        g.setColor(new Color(72, 75, 83));
        g.fillRect(0, 0, 1, 2);
    }

    public static void drawRands(Graphics g, char[] rands) {
        g.setColor(new Color(0xE0E0E0));
        g.setFont(new Font("Arial", 3, 24));
        g.drawString("" + rands[0], 1, 27);
        g.drawString("" + rands[1], 19, 25);
        g.drawString("" + rands[2], 39, 27);
        g.drawString("" + rands[3], 58, 26);
    }

    public static char[] generateCheckCode() {
        String chars = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        char[] rands = new char[4];
        for (int i = 0; i < 4; ++i) {
            int rand = (int)(Math.random() * 62.0);
            rands[i] = chars.charAt(rand);
        }
        return rands;
    }
}

