/*
 * Decompiled with CFR 0.152.
 */
package com.github.surpassm.common.tool.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;

public class JsonUtils {
    public static String objectToJson(Object data, ObjectMapper mapper) {
        try {
            String string = mapper.writeValueAsString(data);
            return string;
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T jsonToPojo(String jsonData, Class<T> beanType, ObjectMapper mapper) {
        try {
            Object t = mapper.readValue(jsonData, beanType);
            return (T)t;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> List<T> jsonToList(String jsonData, Class<T> beanType, ObjectMapper mapper) {
        JavaType javaType = mapper.getTypeFactory().constructParametricType(List.class, new Class[]{beanType});
        try {
            List list = (List)mapper.readValue(jsonData, javaType);
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

