/*
 * Decompiled with CFR 0.152.
 */
package com.github.surpassm.common.tool.util;

import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LatLonUtil {
    private static final double PI = 3.14159265;
    private static final double EARTH_RADIUS = 6378137.0;
    private static final double RAD = Math.PI / 180;
    private static double EARTH_RADIUS1 = 6371.393;

    public static Map<String, Double> getAround(double lat, double lon, int raidus) {
        Double latitude = lat;
        Double longitude = lon;
        Double degree = 111293.63611111112;
        double raidusMile = raidus;
        Double dpmLat = 1.0 / degree;
        Double radiusLat = dpmLat * raidusMile;
        Double minLat = latitude - radiusLat;
        Double maxLat = latitude + radiusLat;
        Double mpdLng = degree * Math.cos(latitude * 0.017453292500000002);
        Double dpmLng = 1.0 / mpdLng;
        Double radiusLng = dpmLng * raidusMile;
        Double minLng = longitude - radiusLng;
        Double maxLng = longitude + radiusLng;
        HashMap<String, Double> result = new HashMap<String, Double>();
        result.put("minLat", minLat);
        result.put("minLng", minLng);
        result.put("maxLat", maxLat);
        result.put("maxLng", maxLng);
        return result;
    }

    public static double distanceByLongNLat(double long1, double lat1, double long2, double lat2) {
        lat1 = lat1 * Math.PI / 180.0;
        lat2 = lat2 * Math.PI / 180.0;
        double a = lat1 - lat2;
        double b = (long1 - long2) * Math.PI / 180.0;
        double sa2 = Math.sin(a / 2.0);
        double sb2 = Math.sin(b / 2.0);
        double d = 1.2756274E7 * Math.asin(Math.sqrt(sa2 * sa2 + Math.cos(lat1) * Math.cos(lat2) * sb2 * sb2));
        return d;
    }

    private static double rad(double d) {
        return d * Math.PI / 180.0;
    }

    public static double GetDistance(double lat1, double lng1, double lat2, double lng2) {
        double radLat1 = LatLonUtil.rad(lat1);
        double radLat2 = LatLonUtil.rad(lat2);
        double a = radLat1 - radLat2;
        double b = LatLonUtil.rad(lng1) - LatLonUtil.rad(lng2);
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        s *= EARTH_RADIUS1;
        s = Math.round(s * 1000.0);
        return s;
    }

    public static boolean isInCircle(double radius, double lat1, double lng1, double lat2, double lng2) {
        double radLat1 = LatLonUtil.rad(lat1);
        double radLat2 = LatLonUtil.rad(lat2);
        double a = radLat1 - radLat2;
        double b = LatLonUtil.rad(lng1) - LatLonUtil.rad(lng2);
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        s *= 6378137.0;
        return (s = (double)(Math.round(s * 10000.0) / 10000L)) < radius;
    }

    public static boolean isInRectangleArea(double lat, double lng, double minLat, double maxLat, double minLng, double maxLng) {
        if (LatLonUtil.isInRange(lat, minLat, maxLat)) {
            if (minLng * maxLng > 0.0) {
                return LatLonUtil.isInRange(lng, minLng, maxLng);
            }
            if (Math.abs(minLng) + Math.abs(maxLng) < 180.0) {
                return LatLonUtil.isInRange(lng, minLng, maxLng);
            }
            double left = Math.max(minLng, maxLng);
            double right = Math.min(minLng, maxLng);
            return LatLonUtil.isInRange(lng, left, 180.0) || LatLonUtil.isInRange(lng, right, -180.0);
        }
        return false;
    }

    public static boolean isInRange(double point, double left, double right) {
        return point >= Math.min(left, right) && point <= Math.max(left, right);
    }

    public static boolean isInPolygon(Point2D.Double point, List<Point2D.Double> pts) {
        int n = pts.size();
        boolean boundOrVertex = true;
        int intersectCount = 0;
        double precision = 2.0E-10;
        Point2D.Double p = point;
        Point2D.Double p1 = pts.get(0);
        for (int i = 1; i <= n; ++i) {
            if (p.equals(p1)) {
                return true;
            }
            Point2D.Double p2 = pts.get(i % n);
            if (p.x < Math.min(p1.x, p2.x) || p.x > Math.max(p1.x, p2.x)) {
                p1 = p2;
                continue;
            }
            if (p.x > Math.min(p1.x, p2.x) && p.x < Math.max(p1.x, p2.x)) {
                if (p.y <= Math.max(p1.y, p2.y)) {
                    if (p1.x == p2.x && p.y >= Math.min(p1.y, p2.y)) {
                        return true;
                    }
                    if (p1.y == p2.y) {
                        if (p1.y == p.y) {
                            return true;
                        }
                        ++intersectCount;
                    } else {
                        double xinters = (p.x - p1.x) * (p2.y - p1.y) / (p2.x - p1.x) + p1.y;
                        if (Math.abs(p.y - xinters) < precision) {
                            return true;
                        }
                        if (p.y < xinters) {
                            ++intersectCount;
                        }
                    }
                }
            } else if (p.x == p2.x && p.y <= p2.y) {
                Point2D.Double p3 = pts.get((i + 1) % n);
                intersectCount = p.x >= Math.min(p1.x, p3.x) && p.x <= Math.max(p1.x, p3.x) ? ++intersectCount : (intersectCount += 2);
            }
            p1 = p2;
        }
        return intersectCount % 2 != 0;
    }
}

