/*
 * Decompiled with CFR 0.152.
 */
package com.github.surpassm.common.tool.util;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;

public class SystemClock {
    private static final String THREAD_NAME = "system.clock";
    private static final SystemClock MILLIS_CLOCK = new SystemClock(1L);
    private final long precision;
    private final AtomicLong now;

    private SystemClock(long precision) {
        this.precision = precision;
        this.now = new AtomicLong(System.currentTimeMillis());
        this.scheduleClockUpdating();
    }

    public static SystemClock millisClock() {
        return MILLIS_CLOCK;
    }

    private void scheduleClockUpdating() {
        ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new BasicThreadFactory.Builder().namingPattern(THREAD_NAME).daemon(true).build());
        scheduler.scheduleAtFixedRate(() -> this.now.set(System.currentTimeMillis()), this.precision, this.precision, TimeUnit.MILLISECONDS);
    }

    public long now() {
        return this.now.get();
    }
}

