/*
 * Decompiled with CFR 0.152.
 */
package com.github.surpassm.common.tool.util;

import java.util.regex.Pattern;

public class ValidateUtil {
    private static final Pattern P_MOBILE_PHONE = Pattern.compile("^1(3|4|5|7|8)\\d{9}$");
    private static final Pattern REALRNAME = Pattern.compile("^[\u4e00-\u9fa5]{2,6}|(?=[a-zA-Z])[a-zA-Z\\s.]{2,20}$/g");
    private static final Pattern PASSWORD = Pattern.compile("^(?![A-Z]+$)(?![a-z]+$)(?!\\d+$)(?![\\W_]+$)[^\u4e00-\u9fa5]\\S{5,17}$");
    private static final Pattern BANKCODE = Pattern.compile("(([1-9])[\\d]{18})|([1-9])[\\d]{15}");
    private static final Pattern IDENTITY_NO = Pattern.compile("(^[1-9]\\d{5}(18|19|([23]\\d))\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{3}[0-9Xx]$)|(^[1-9]\\d{5}\\d{2}((0[1-9])|(10|11|12))(([0-2][1-9])|10|20|30|31)\\d{2}$)");

    public static boolean isIdentityNo(String identityNo) {
        return identityNo != null && IDENTITY_NO.matcher(identityNo).matches();
    }

    public static boolean isMobilePhone(String str) {
        return str != null && P_MOBILE_PHONE.matcher(str).matches();
    }

    public static boolean isRealName(String str) {
        return str != null && REALRNAME.matcher(str).matches();
    }

    public static boolean isPassword(String str) {
        return str != null && PASSWORD.matcher(str).matches();
    }

    public static boolean isBankCode(String str) {
        return str != null && BANKCODE.matcher(str).matches();
    }
}

