/*
 * Decompiled with CFR 0.152.
 */
package com.github.surpassm.config.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.surpassm.common.jackson.Result;
import com.github.surpassm.config.annotation.SerializedField;
import com.github.surpassm.config.json.codec.AesEncryptUtils;
import com.github.surpassm.security.properties.SecurityProperties;
import java.util.Objects;
import javax.annotation.Resource;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.Order;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@Order(value=1)
@ControllerAdvice(basePackages={"com.liaoin.demo.controller"})
public class SurpassmResponseBodyAdvice
implements ResponseBodyAdvice {
    private String[] includes = new String[0];
    private String[] excludes = new String[0];
    private boolean outEncode = false;
    @Resource
    private ObjectMapper objectMapper;
    @Resource
    private SecurityProperties securityProperties;

    public boolean supports(MethodParameter methodParameter, Class aClass) {
        return true;
    }

    public Object beforeBodyWrite(Object body, MethodParameter methodParameter, MediaType mediaType, Class aClass, ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse) {
        this.includes = new String[0];
        this.excludes = new String[0];
        this.outEncode = false;
        if (body == null) {
            return null;
        }
        if (Objects.requireNonNull(methodParameter.getMethod()).isAnnotationPresent(SerializedField.class)) {
            SerializedField serializedField = (SerializedField)methodParameter.getMethodAnnotation(SerializedField.class);
            if (serializedField == null) {
                return body;
            }
            this.includes = serializedField.includes();
            this.excludes = serializedField.excludes();
            this.outEncode = serializedField.outEncode();
            if (body instanceof Result) {
                Result result = (Result)body;
                Object data = result.getData();
                try {
                    String content = this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(data);
                    if (!StringUtils.hasText((String)this.securityProperties.getEncryptKey())) {
                        throw new NullPointerException("\u8bf7\u914d\u7f6esurpassm.security.encrypt-key");
                    }
                    result.setData(AesEncryptUtils.aesEncrypt(content, this.securityProperties.getEncryptKey()));
                    return result;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return body;
    }
}

