/*
 * Decompiled with CFR 0.152.
 */
package com.github.surpassm.config.token;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.surpassm.common.jackson.Result;
import com.github.surpassm.common.jackson.ResultCode;
import com.github.surpassm.security.properties.SecurityProperties;
import java.io.IOException;
import java.io.PrintWriter;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

@Component
public class TokenInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = LoggerFactory.getLogger(TokenInterceptor.class);
    @Resource
    private ObjectMapper objectMapper;
    @Resource
    private SecurityProperties securityProperties;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String token = request.getHeader(this.securityProperties.getHeaderKey());
        if (token != null) {
            request.setAttribute(this.securityProperties.getHeaderKey(), (Object)token);
            return true;
        }
        this.response(request, response);
        return false;
    }

    private void response(HttpServletRequest request, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-store");
        response.setHeader("Access-Control-Allow-Origin", "*");
        try (PrintWriter out = response.getWriter();){
            log.error("\u8bf7\u6c42\u5730\u5740:" + request.getRequestURI() + ResultCode.PERMISSION_NO_ACCESS.getMsg() + ",\u8bf7\u643a\u5e26token");
            out.write(this.objectMapper.writeValueAsString((Object)new Result(ResultCode.PERMISSION_NO_ACCESS.getCode(), ResultCode.PERMISSION_NO_ACCESS.getMsg(), "")));
            out.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

