/*
 * Decompiled with CFR 0.152.
 */
package com.github.surpassm.config.token;

import com.github.surpassm.config.annotation.AuthorizationToken;
import com.github.surpassm.security.properties.SecurityProperties;
import javax.annotation.Resource;
import org.springframework.core.MethodParameter;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.multipart.support.MissingServletRequestPartException;

@Component
public class TokenMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    @Resource
    private SecurityProperties securityProperties;

    public boolean supportsParameter(MethodParameter methodParameter) {
        return methodParameter.getParameterType().isAssignableFrom(String.class) && methodParameter.hasParameterAnnotation(AuthorizationToken.class);
    }

    public Object resolveArgument(MethodParameter methodParameter, ModelAndViewContainer modelAndViewContainer, NativeWebRequest nativeWebRequest, WebDataBinderFactory webDataBinderFactory) throws Exception {
        String token = (String)nativeWebRequest.getAttribute(this.securityProperties.getHeaderKey(), 0);
        if (token != null) {
            return token;
        }
        throw new MissingServletRequestPartException(this.securityProperties.getHeaderKey());
    }
}

