/*
 * Decompiled with CFR 0.152.
 */
package com.github.surpassm.config.token;

import com.github.surpassm.config.token.TokenInterceptor;
import com.github.surpassm.config.token.TokenMethodArgumentResolver;
import com.github.surpassm.security.properties.SecurityProperties;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class WebAppConfigurer
implements WebMvcConfigurer {
    @Resource
    private TokenMethodArgumentResolver tokenMethodArgumentResolver;
    @Resource
    private TokenInterceptor tokenInterceptor;
    @Resource
    private SecurityProperties securityProperties;

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        argumentResolvers.add(this.tokenMethodArgumentResolver);
    }

    public void addInterceptors(InterceptorRegistry registry) {
        InterceptorRegistration interceptorRegistration = registry.addInterceptor((HandlerInterceptor)this.tokenInterceptor);
        String[] noVerify = this.securityProperties.getNoVerify();
        if (noVerify != null && noVerify.length != 0) {
            interceptorRegistration.excludePathPatterns(Arrays.asList(noVerify));
        }
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        try {
            String path = new File("").getCanonicalPath();
            registry.addResourceHandler(new String[]{"/upload/**"}).addResourceLocations(new String[]{"file:///" + path + "/upload/"});
            registry.addResourceHandler(new String[]{"/static/**"}).addResourceLocations(new String[]{"file:///" + path + "/static/"});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**").allowedOrigins(new String[]{"*"}).allowedMethods(new String[]{"GET", "POST", "OPTIONS", "PUT"}).allowedHeaders(new String[]{this.securityProperties.getHeaderLogin(), this.securityProperties.getHeaderKey(), "Content-Type", "X-Requested-With", "accept", "Origin", "Access-Control-Request-Method", "Access-Control-Request-Headers"}).exposedHeaders(new String[]{"Access-Control-Allow-Origin", "Access-Control-Allow-Credentials"}).allowCredentials(true).maxAge(36000L);
    }
}

