/*
 * Decompiled with CFR 0.152.
 */
package com.github.surpassm.security.config;

import com.github.surpassm.security.properties.SecurityProperties;
import com.github.surpassm.security.properties.app.Oauth2ClientProperties;
import java.util.ArrayList;
import javax.annotation.Resource;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.oauth2.config.annotation.builders.InMemoryClientDetailsServiceBuilder;
import org.springframework.security.oauth2.config.annotation.configurers.ClientDetailsServiceConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableAuthorizationServer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerEndpointsConfigurer;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.TokenEnhancer;
import org.springframework.security.oauth2.provider.token.TokenEnhancerChain;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;

@Configuration
@EnableAuthorizationServer
public class Oauth2ServerConfig
extends AuthorizationServerConfigurerAdapter {
    @Resource
    private AuthenticationManager authenticationManager;
    @Resource
    private UserDetailsService userDetailsService;
    @Resource
    private SecurityProperties securityProperties;
    @Resource
    private TokenStore redisTokenStore;
    @Autowired(required=false)
    private JwtAccessTokenConverter jwtAccessTokenConverter;
    @Autowired(required=false)
    private TokenEnhancer jwtTokenEnhancer;

    public void configure(AuthorizationServerEndpointsConfigurer endpointsConfigurer) throws Exception {
        endpointsConfigurer.tokenStore(this.redisTokenStore).authenticationManager(this.authenticationManager).userDetailsService(this.userDetailsService);
        if (this.jwtAccessTokenConverter != null && this.jwtTokenEnhancer != null) {
            TokenEnhancerChain chain = new TokenEnhancerChain();
            ArrayList<Object> enhancers = new ArrayList<Object>();
            enhancers.add(this.jwtTokenEnhancer);
            enhancers.add(this.jwtAccessTokenConverter);
            chain.setTokenEnhancers(enhancers);
            endpointsConfigurer.tokenEnhancer((TokenEnhancer)chain).accessTokenConverter((AccessTokenConverter)this.jwtAccessTokenConverter);
        }
    }

    public void configure(ClientDetailsServiceConfigurer clients) throws Exception {
        InMemoryClientDetailsServiceBuilder builder = clients.inMemory();
        if (ArrayUtils.isNotEmpty((Object[])this.securityProperties.getOauth2().getClients())) {
            for (Oauth2ClientProperties config : this.securityProperties.getOauth2().getClients()) {
                builder.withClient(config.getClientId()).secret(config.getClientIdSecret()).accessTokenValiditySeconds(config.getAccessTokenValiditySeconds()).refreshTokenValiditySeconds(config.getRefreshTokenValiditySeconds()).authorizedGrantTypes(new String[]{"refresh_token", "password"}).scopes(new String[]{"all", "read", "write"});
            }
        }
    }
}

