/*
 * Decompiled with CFR 0.152.
 */
package com.github.surpassm.security.config;

import com.github.surpassm.security.code.sms.DefaultSmsCodeSenderImpl;
import com.github.surpassm.security.code.sms.SmsCodeSender;
import com.github.surpassm.security.logout.LiaoinLogoutSuccessHandler;
import com.github.surpassm.security.properties.SecurityProperties;
import com.github.surpassm.security.session.LiaoinExpiredSessionStrategy;
import com.github.surpassm.security.session.LiaoinInvalidSessionStrategy;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.session.InvalidSessionStrategy;
import org.springframework.security.web.session.SessionInformationExpiredStrategy;

@Configuration
public class SecurityBeanConfig {
    @Resource
    private SecurityProperties securityProperties;

    @Bean
    @ConditionalOnMissingBean(value={InvalidSessionStrategy.class})
    public InvalidSessionStrategy invalidSessionStrategy() {
        return new LiaoinInvalidSessionStrategy(this.securityProperties.getSession().getSessionInvalidUrl());
    }

    @Bean
    @ConditionalOnMissingBean(value={SessionInformationExpiredStrategy.class})
    public SessionInformationExpiredStrategy sessionInformationExpiredStrategy() {
        return new LiaoinExpiredSessionStrategy(this.securityProperties.getSession().getSessionInvalidUrl());
    }

    @Bean
    @ConditionalOnMissingBean(value={LiaoinLogoutSuccessHandler.class})
    public LogoutSuccessHandler logoutSuccessHandler() {
        return new LiaoinLogoutSuccessHandler(this.securityProperties);
    }

    @Bean
    public BCryptPasswordEncoder bCryptPasswordEncoder() {
        return new BCryptPasswordEncoder();
    }

    @Bean
    @ConditionalOnMissingBean(value={SmsCodeSender.class})
    public SmsCodeSender smsCodeSender() {
        return new DefaultSmsCodeSenderImpl();
    }
}

