/*
 * Decompiled with CFR 0.152.
 */
package com.github.surpassm.security.config;

import com.github.surpassm.security.authorize.AuthorizeCofigManager;
import com.github.surpassm.security.filter.SurpassmAuthenticationManager;
import com.github.surpassm.security.handler.SurpassmAuthenctiationFailureHandler;
import com.github.surpassm.security.handler.SurpassmAuthenticationSuccessHandler;
import com.github.surpassm.security.mobile.MobileCodeAuthenticationSecurityConfig;
import com.github.surpassm.security.properties.SecurityProperties;
import javax.annotation.Resource;
import javax.servlet.Filter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.csrf.CookieCsrfTokenRepository;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.session.InvalidSessionStrategy;
import org.springframework.security.web.session.SessionInformationExpiredStrategy;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.cors.CorsUtils;

@Configuration
@EnableWebSecurity
public class SecurityConfiguration
extends WebSecurityConfigurerAdapter {
    @Resource
    private SecurityProperties securityProperties;
    @Resource
    private SurpassmAuthenctiationFailureHandler surpassmAuthenctiationFailureHandler;
    @Resource
    private SurpassmAuthenticationSuccessHandler surpassmAuthenticationSuccessHandler;
    @Resource
    private AuthorizeCofigManager authorizeCofigManager;
    @Resource
    private InvalidSessionStrategy invalidSessionStrategy;
    @Resource
    private SessionInformationExpiredStrategy sessionInformationExpiredStrategy;
    @Resource
    private LogoutSuccessHandler logoutSuccessHandler;
    @Resource
    private MobileCodeAuthenticationSecurityConfig mobileCodeAuthenticationSecurityConfig;

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)http.formLogin().loginPage(this.securityProperties.getDefaultUnauthenticatedUrl()).loginProcessingUrl(this.securityProperties.getDefaultLoginProcessingUrlFrom())).successHandler((AuthenticationSuccessHandler)this.surpassmAuthenticationSuccessHandler)).failureHandler((AuthenticationFailureHandler)this.surpassmAuthenctiationFailureHandler)).usernameParameter(this.securityProperties.getUsernameParameter()).passwordParameter(this.securityProperties.getPasswordParameter()).and()).logout().logoutUrl(this.securityProperties.getDefaultLoginOutUrl()).logoutSuccessHandler(this.logoutSuccessHandler).deleteCookies(new String[]{"SESSION_ID"}).and()).cors().and()).csrf().csrfTokenRepository((CsrfTokenRepository)CookieCsrfTokenRepository.withHttpOnlyFalse()).disable();
        http.apply((SecurityConfigurerAdapter)this.mobileCodeAuthenticationSecurityConfig);
        http.headers().frameOptions().sameOrigin();
        this.authorizeCofigManager.config(http.authorizeRequests());
        SurpassmAuthenticationManager manager = new SurpassmAuthenticationManager();
        manager.setAuthenticationManager((AuthenticationManager)http.getSharedObject(AuthenticationManager.class));
        http.addFilterAfter((Filter)manager, UsernamePasswordAuthenticationFilter.class);
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry registry = http.authorizeRequests();
        ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)registry.requestMatchers(new RequestMatcher[]{CorsUtils::isPreFlightRequest})).permitAll();
    }

    @Bean
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }
}

