/*
 * Decompiled with CFR 0.152.
 */
package com.github.surpassm.security.config;

import com.github.surpassm.security.jwt.SurpassmJwtEnhancer;
import com.github.surpassm.security.properties.SecurityProperties;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.security.oauth2.provider.token.TokenEnhancer;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.store.JwtTokenStore;
import org.springframework.security.oauth2.provider.token.store.redis.RedisTokenStore;

@Configuration
public class TokenStoreConfig {
    @Resource
    private RedisConnectionFactory redisConnectionFactory;

    @Bean
    @ConditionalOnProperty(prefix="surpassm.security.oauth2", name={"storeType"}, havingValue="redis", matchIfMissing=true)
    public TokenStore redisTokenStore() {
        return new RedisTokenStore(this.redisConnectionFactory);
    }

    @Configuration
    @ConditionalOnProperty(prefix="surpassm.security.oauth2", name={"storeType"}, havingValue="jwt")
    public static class JwtTokenConfig {
        @Resource
        private SecurityProperties securityProperties;

        @Bean
        public TokenStore jwtTokenStore() {
            return new JwtTokenStore(this.jwtAccessTokenConverter());
        }

        @Bean
        public JwtAccessTokenConverter jwtAccessTokenConverter() {
            JwtAccessTokenConverter accessTokenConverter = new JwtAccessTokenConverter();
            accessTokenConverter.setSigningKey(this.securityProperties.getOauth2().getSecretKey());
            return accessTokenConverter;
        }

        @Bean
        @ConditionalOnMissingBean(name={"jwtTokenEnhancer"})
        public TokenEnhancer jwtTokenEnhancer() {
            return new SurpassmJwtEnhancer();
        }
    }
}

