/*
 * Decompiled with CFR 0.152.
 */
package com.github.surpassm.security.controller;

import com.github.surpassm.common.jackson.Result;
import com.github.surpassm.security.properties.SecurityProperties;
import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SecurityController {
    private static final Logger log = LoggerFactory.getLogger(SecurityController.class);
    private RequestCache requestCache = new HttpSessionRequestCache();
    private RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
    @Resource
    private SecurityProperties securityProperties;

    @RequestMapping(value={"/authentication/require"})
    @ResponseStatus(code=HttpStatus.OK)
    public Result requireAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession httpSession;
        Cookie[] cookies;
        SavedRequest savedRequest = this.requestCache.getRequest(request, response);
        if (savedRequest != null) {
            String targetUrl = savedRequest.getRedirectUrl();
            log.info("\u5f15\u53d1\u8df3\u8f6c\u7684\u8bf7\u6c42\u662f:" + targetUrl);
            String string = ".html";
            if (StringUtils.endsWithIgnoreCase((CharSequence)targetUrl, (CharSequence)string)) {
                this.redirectStrategy.sendRedirect(request, response, this.securityProperties.getLoginPage());
            }
        }
        if ((cookies = request.getCookies()) != null) {
            for (Cookie cookie : cookies) {
                cookie.setMaxAge(0);
                cookie.setPath("/");
                response.addCookie(cookie);
            }
        }
        if (null != (httpSession = request.getSession())) {
            httpSession.invalidate();
        }
        return new Result(HttpStatus.FORBIDDEN.value(), "\u65e0\u8bbf\u95ee\u6743\u9650");
    }
}

