/*
 * Decompiled with CFR 0.152.
 */
package com.github.surpassm.security.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.surpassm.common.jackson.Result;
import com.github.surpassm.common.jackson.ResultCode;
import com.github.surpassm.security.enums.LoginResponseType;
import com.github.surpassm.security.properties.SecurityProperties;
import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.stereotype.Component;

@Component(value="surpassmAuthenctiationFailureHandler")
public class SurpassmAuthenctiationFailureHandler
extends SimpleUrlAuthenticationFailureHandler {
    private static final Logger log = LoggerFactory.getLogger(SurpassmAuthenctiationFailureHandler.class);
    @Resource
    private ObjectMapper objectMapper;
    @Resource
    private SecurityProperties securityProperties;

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        this.logger.info((Object)"\u767b\u5f55\u5931\u8d25");
        if (LoginResponseType.JSON.equals((Object)this.securityProperties.getLoginType())) {
            response.setStatus(HttpStatus.OK.value());
            response.setContentType("application/json;charset=UTF-8");
            response.getWriter().write(this.objectMapper.writeValueAsString((Object)new Result(HttpStatus.UNAUTHORIZED.value(), ResultCode.ERROR.getMsg())));
        } else {
            super.onAuthenticationFailure(request, response, exception);
        }
    }
}

