/*
 * Decompiled with CFR 0.152.
 */
package com.github.surpassm.security.handler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.surpassm.common.jackson.Result;
import com.github.surpassm.security.exception.SurpassmAuthenticationException;
import com.github.surpassm.security.properties.SecurityProperties;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.DefaultOAuth2RefreshToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.security.oauth2.common.exceptions.UnapprovedClientAuthenticationException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.TokenRequest;
import org.springframework.security.oauth2.provider.token.AuthorizationServerTokenServices;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.stereotype.Component;

@Component(value="surpassmAuthenticationSuccessHandler")
public class SurpassmAuthenticationSuccessHandler
extends SavedRequestAwareAuthenticationSuccessHandler {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @Resource
    private ObjectMapper objectMapper;
    @Resource
    private ClientDetailsService clientDetailsService;
    @Resource
    private TokenStore tokenStore;
    @Resource
    private AuthorizationServerTokenServices myDefaultTokenServices;
    @Resource
    private SecurityProperties securityProperties;

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        this.logger.info("\u767b\u5f55\u6210\u529f");
        String header = request.getHeader(this.securityProperties.getHeaderLogin());
        String basic = this.securityProperties.getHeaderLoginValue();
        if (header == null || !header.startsWith(basic)) {
            throw new SurpassmAuthenticationException("\u8bf7\u6c42\u5934\u4e2d\u65e0client\u4fe1\u606f");
        }
        String[] tokens = this.extractAndDecodeHeader(header, request);
        assert (tokens.length == 2);
        String clientId = tokens[0];
        String clientSecret = tokens[1];
        ClientDetails clientDetails = null;
        try {
            clientDetails = this.clientDetailsService.loadClientByClientId(clientId);
        }
        catch (Exception e) {
            throw new UnapprovedClientAuthenticationException("clientSecret\u4e0d\u5339\u914d" + clientId);
        }
        if (clientDetails == null) {
            throw new UnapprovedClientAuthenticationException("client\u914d\u7f6e\u4e0d\u5b58\u5728" + clientId);
        }
        if (!StringUtils.equals((CharSequence)clientDetails.getClientSecret(), (CharSequence)clientSecret)) {
            throw new UnapprovedClientAuthenticationException("clientSecret\u4e0d\u5339\u914d" + clientId);
        }
        response.setContentType("application/json;charset=UTF-8");
        Object principal = authentication.getPrincipal();
        TokenRequest tokenRequest = new TokenRequest((Map)MapUtils.EMPTY_SORTED_MAP, clientId, (Collection)clientDetails.getScope(), "custom");
        OAuth2Request oAuth2Request = tokenRequest.createOAuth2Request(clientDetails);
        OAuth2Authentication oAuth2Authentication = new OAuth2Authentication(oAuth2Request, authentication);
        OAuth2AccessToken oAuth2AccessToken = this.myDefaultTokenServices.createAccessToken(oAuth2Authentication);
        HashMap<String, Object> additionalInformation = new HashMap<String, Object>(1);
        additionalInformation.put("userInfo", principal);
        ((DefaultOAuth2AccessToken)oAuth2AccessToken).setAdditionalInformation(additionalInformation);
        response.getWriter().write(this.objectMapper.writeValueAsString((Object)new Result(oAuth2AccessToken)));
    }

    private String[] extractAndDecodeHeader(String header, HttpServletRequest request) throws IOException {
        byte[] decoded;
        byte[] base64Token = header.substring(6).getBytes("UTF-8");
        try {
            decoded = Base64.decode((byte[])base64Token);
        }
        catch (IllegalArgumentException e) {
            throw new BadCredentialsException("Failed to decode basic authentication token");
        }
        String token = new String(decoded, "UTF-8");
        int delim = token.indexOf(":");
        if (delim == -1) {
            throw new BadCredentialsException("Invalid basic authentication token");
        }
        return new String[]{token.substring(0, delim), token.substring(delim + 1)};
    }

    public OAuth2AccessToken refresh(String refreshToken, String head) throws IOException {
        String[] tokens = this.extractAndDecodeHeader(head, null);
        assert (tokens.length == 2);
        String clientId = tokens[0];
        String clientSecret = tokens[1];
        ClientDetails clientDetails = null;
        try {
            clientDetails = this.clientDetailsService.loadClientByClientId(clientId);
        }
        catch (Exception e) {
            throw new UnapprovedClientAuthenticationException("clientSecret\u4e0d\u5339\u914d" + clientId);
        }
        if (clientDetails == null) {
            throw new UnapprovedClientAuthenticationException("client\u914d\u7f6e\u4e0d\u5b58\u5728" + clientId);
        }
        if (!StringUtils.equals((CharSequence)clientDetails.getClientSecret(), (CharSequence)clientSecret)) {
            throw new UnapprovedClientAuthenticationException("clientSecret\u4e0d\u5339\u914d" + clientId);
        }
        TokenRequest tokenRequest = new TokenRequest((Map)MapUtils.EMPTY_SORTED_MAP, clientId, (Collection)clientDetails.getScope(), "custom");
        OAuth2AccessToken oAuth2AccessToken = this.myDefaultTokenServices.refreshAccessToken(refreshToken, tokenRequest);
        OAuth2Authentication authentication = this.tokenStore.readAuthenticationForRefreshToken(oAuth2AccessToken.getRefreshToken());
        Object principal = authentication.getUserAuthentication().getPrincipal();
        HashMap<String, Object> additionalInformation = new HashMap<String, Object>(16);
        additionalInformation.put("userInfo", principal);
        ((DefaultOAuth2AccessToken)oAuth2AccessToken).setAdditionalInformation(additionalInformation);
        this.tokenStore.storeAccessToken(oAuth2AccessToken, authentication);
        return oAuth2AccessToken;
    }

    public void deleteOauth2AccessToken(String refreshToken) {
        DefaultOAuth2RefreshToken oAuth2RefreshToken = new DefaultOAuth2RefreshToken(refreshToken);
        this.tokenStore.removeAccessTokenUsingRefreshToken((OAuth2RefreshToken)oAuth2RefreshToken);
    }
}

