/*
 * Decompiled with CFR 0.152.
 */
package com.github.surpassm.security.logout;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.surpassm.common.jackson.Result;
import com.github.surpassm.security.properties.SecurityProperties;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

public class LiaoinLogoutSuccessHandler
implements LogoutSuccessHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private SecurityProperties securityProperties;
    private ObjectMapper objectMapper = new ObjectMapper();

    public LiaoinLogoutSuccessHandler(SecurityProperties securityProperties) {
        this.securityProperties = securityProperties;
    }

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        this.logger.info("\u9000\u51fa\u6210\u529f");
        String signOutUrl = this.securityProperties.getSignOutUrl();
        if (StringUtils.isBlank((CharSequence)signOutUrl)) {
            response.setContentType("application/json;charset=UTF-8");
            response.getWriter().write(this.objectMapper.writeValueAsString((Object)new Result(signOutUrl)));
        } else {
            response.sendRedirect(signOutUrl);
        }
    }
}

