/*
 * Decompiled with CFR 0.152.
 */
package com.github.surpassm.security.mobile;

import com.github.surpassm.security.mobile.MobileCodeAuthenticationToken;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;

public class MobileCodeAuthenticationProvider
implements AuthenticationProvider {
    private UserDetailsService userDetailsService;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        MobileCodeAuthenticationToken token = (MobileCodeAuthenticationToken)authentication;
        UserDetails mobile = this.userDetailsService.loadUserByUsername((String)token.getPrincipal());
        if (mobile == null) {
            throw new InternalAuthenticationServiceException("\u65e0\u6cd5\u83b7\u53d6\u7528\u6237\u4fe1\u606f");
        }
        MobileCodeAuthenticationToken authenticationResult = new MobileCodeAuthenticationToken(mobile, mobile.getAuthorities());
        authenticationResult.setDetails(token.getDetails());
        return authenticationResult;
    }

    public boolean supports(Class<?> authentication) {
        return MobileCodeAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public UserDetailsService getUserDetailsService() {
        return this.userDetailsService;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MobileCodeAuthenticationProvider)) {
            return false;
        }
        MobileCodeAuthenticationProvider other = (MobileCodeAuthenticationProvider)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UserDetailsService this$userDetailsService = this.getUserDetailsService();
        UserDetailsService other$userDetailsService = other.getUserDetailsService();
        return !(this$userDetailsService == null ? other$userDetailsService != null : !this$userDetailsService.equals(other$userDetailsService));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MobileCodeAuthenticationProvider;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UserDetailsService $userDetailsService = this.getUserDetailsService();
        result = result * 59 + ($userDetailsService == null ? 43 : $userDetailsService.hashCode());
        return result;
    }

    public String toString() {
        return "MobileCodeAuthenticationProvider(userDetailsService=" + this.getUserDetailsService() + ")";
    }
}

