/*
 * Decompiled with CFR 0.152.
 */
package com.github.surpassm.security.mobile;

import com.github.surpassm.security.mobile.MobileCodeAuthenticationFilter;
import com.github.surpassm.security.mobile.MobileCodeAuthenticationProvider;
import javax.annotation.Resource;
import javax.servlet.Filter;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.SecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.DefaultSecurityFilterChain;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.preauth.AbstractPreAuthenticatedProcessingFilter;
import org.springframework.stereotype.Component;

@Component
public class MobileCodeAuthenticationSecurityConfig
extends SecurityConfigurerAdapter<DefaultSecurityFilterChain, HttpSecurity> {
    @Resource
    private AuthenticationSuccessHandler surpassmAuthenticationSuccessHandler;
    @Resource
    private AuthenticationFailureHandler surpassmAuthenctiationFailureHandler;
    @Resource
    private UserDetailsService userDetailsService;
    @Resource
    private Filter mobileFilter;

    public void configure(HttpSecurity http) throws Exception {
        MobileCodeAuthenticationFilter filter = new MobileCodeAuthenticationFilter();
        filter.setAuthenticationManager((AuthenticationManager)http.getSharedObject(AuthenticationManager.class));
        filter.setAuthenticationSuccessHandler(this.surpassmAuthenticationSuccessHandler);
        filter.setAuthenticationFailureHandler(this.surpassmAuthenctiationFailureHandler);
        MobileCodeAuthenticationProvider provider = new MobileCodeAuthenticationProvider();
        provider.setUserDetailsService(this.userDetailsService);
        http.authenticationProvider((AuthenticationProvider)provider).addFilterAfter((Filter)filter, UsernamePasswordAuthenticationFilter.class);
        http.addFilterBefore(this.mobileFilter, AbstractPreAuthenticatedProcessingFilter.class);
    }
}

