/*
 * Decompiled with CFR 0.152.
 */
package com.github.surpassm.security.mobile;

import com.github.surpassm.security.mobile.MobileException;
import com.github.surpassm.security.mobile.MobileProcessorService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.stereotype.Component;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class MobileFilter
extends OncePerRequestFilter
implements InitializingBean {
    @Resource
    private AuthenticationFailureHandler authenticationFailureHandler;
    private Map<String, String> urlMap = new HashMap<String, String>(2);
    private AntPathMatcher pathMatcher = new AntPathMatcher();
    @Resource
    private MobileProcessorService mobileProcessorService;

    public void afterPropertiesSet() throws ServletException {
        super.afterPropertiesSet();
        this.urlMap.put("/authentication/mobile", "PHONE");
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String type = this.getValidateCodeType(request);
        if (type != null) {
            this.logger.info((Object)("\u6821\u9a8c\u8bf7\u6c42(" + request.getRequestURI() + ")\u4e2d\u7684\u6548\u9a8c\u624b\u673a\u53f7\u7c7b\u578b\uff1a" + type));
            try {
                this.mobileProcessorService.validatePhone(new ServletWebRequest(request, response));
                this.logger.info((Object)"\u6821\u9a8c\u901a\u8fc7");
            }
            catch (MobileException exception) {
                this.authenticationFailureHandler.onAuthenticationFailure(request, response, (AuthenticationException)exception);
                return;
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private String getValidateCodeType(HttpServletRequest request) {
        String result = null;
        String get = "get";
        if (!StringUtils.equalsIgnoreCase((CharSequence)request.getMethod(), (CharSequence)get)) {
            Set<String> urls = this.urlMap.keySet();
            for (String url : urls) {
                if (!this.pathMatcher.match(url, request.getRequestURI())) continue;
                result = this.urlMap.get(url);
            }
        }
        return result;
    }
}

